/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.dao;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.minijax.cdi.annotation.FieldAnnotationProcessor;
import org.minijax.dao.PersistenceContextAnnotationProcessor;
import org.minijax.dao.PersistenceUtils;
import org.minijax.rs.MinijaxApplicationContext;

public class PersistenceFeature
implements Feature {
    public boolean configure(FeatureContext context) {
        if (!(context instanceof MinijaxApplicationContext)) {
            throw new IllegalArgumentException("Minijax PersistenceFeature only compatible with MinijaxApplication");
        }
        MinijaxApplicationContext app = (MinijaxApplicationContext)context;
        this.registerPersistence(app);
        return true;
    }

    public void registerPersistence(MinijaxApplicationContext app) {
        List<String> names = PersistenceUtils.getNames("META-INF/persistence.xml");
        HashMap<String, ClassLoader> props = new HashMap<String, ClassLoader>();
        props.put("eclipselink.classloader", this.getClass().getClassLoader());
        props.putAll(app.getProperties());
        HashMap<String, EntityManagerFactory> factories = new HashMap<String, EntityManagerFactory>();
        boolean first = true;
        for (String name : names) {
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)name, props);
            factories.put(name, emf);
            if (!first) continue;
            factories.put("", emf);
            first = false;
        }
        app.getInjector().addFieldAnnotationProcessor(PersistenceContext.class, (FieldAnnotationProcessor)new PersistenceContextAnnotationProcessor(factories));
    }
}

