/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.dao;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class PersistenceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceUtils.class);

    PersistenceUtils() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getNames(String fileName) {
        try (InputStream in = PersistenceUtils.class.getClassLoader().getResourceAsStream(fileName);){
            if (in == null) {
                List<String> list2 = Collections.emptyList();
                return list2;
            }
            List<String> list = PersistenceUtils.scanPersistenceXml(in);
            return list;
        }
        catch (Exception ex) {
            LOG.warn("Error reading persistence.xml: {}", (Object)ex.getMessage(), (Object)ex);
            return Collections.emptyList();
        }
    }

    private static List<String> scanPersistenceXml(InputStream in) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Document doc = factory.newDocumentBuilder().parse(in);
        XPathExpression expr = XPathFactory.newInstance().newXPath().compile("/persistence/persistence-unit/@name");
        NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        ArrayList<String> result = new ArrayList<String>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            result.add(((Attr)nodes.item(i)).getValue());
        }
        return result;
    }
}

