/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.dao.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.minijax.commons.MinijaxException;
import org.minijax.json.Json;

@Converter
public class JsonMapConverter
implements AttributeConverter<Map<String, Object>, String> {
    public String convertToDatabaseColumn(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        try {
            return Json.getObjectMapper().writeValueAsString(map);
        }
        catch (JsonProcessingException ex) {
            throw new MinijaxException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Map<String, Object> convertToEntityAttribute(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            return (Map)Json.getObjectMapper().readValue(str, Map.class);
        }
        catch (IOException ex) {
            throw new MinijaxException(ex.getMessage(), (Throwable)ex);
        }
    }
}

