/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.dao;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.minijax.commons.IdUtils;
import org.minijax.dao.BaseEntity;
import org.minijax.dao.converters.InstantConverter;
import org.minijax.dao.converters.UuidConverter;
import org.minijax.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappedSuperclass
public abstract class DefaultBaseEntity
implements BaseEntity {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBaseEntity.class);
    private static final long serialVersionUID = 1L;
    @Id
    @Column(columnDefinition="BINARY(16)")
    @Convert(converter=UuidConverter.class)
    private UUID id = IdUtils.create();
    @Convert(converter=InstantConverter.class)
    private Instant createdDateTime;
    @Convert(converter=InstantConverter.class)
    private Instant updatedDateTime;
    @Convert(converter=InstantConverter.class)
    private Instant deletedDateTime;

    protected DefaultBaseEntity() {
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    @Override
    public Instant getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(Instant createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    @Override
    public Instant getUpdatedDateTime() {
        return this.updatedDateTime;
    }

    public void setUpdatedDateTime(Instant updatedDateTime) {
        this.updatedDateTime = updatedDateTime;
    }

    @Override
    public boolean isDeleted() {
        return this.deletedDateTime != null;
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deletedDateTime = deleted ? Instant.now() : null;
    }

    @Override
    public Instant getDeletedDateTime() {
        return this.deletedDateTime;
    }

    @PrePersist
    public void onPrePersist() {
        this.updatedDateTime = this.createdDateTime = Instant.now();
    }

    @PreUpdate
    public void onPreUpdate() {
        this.updatedDateTime = Instant.now();
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        DefaultBaseEntity other = (DefaultBaseEntity)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toJson() {
        return Json.getObjectMapper().toJson((Object)this);
    }

    public static <T extends DefaultBaseEntity> T fromJson(Class<T> c, String str) {
        return (T)((DefaultBaseEntity)Json.getObjectMapper().fromJson(str, c));
    }

    public <T extends DefaultBaseEntity> void copyNonNullProperties(T other) {
        if (!this.getClass().equals(other.getClass())) {
            throw new IllegalArgumentException("Incorrect type (expected " + this.getClass() + ", actual " + other.getClass() + ")");
        }
        for (Class<?> currClass = this.getClass(); currClass != null; currClass = currClass.getSuperclass()) {
            for (Field field : currClass.getDeclaredFields()) {
                this.copyNonNullField(other, field);
            }
        }
    }

    private <T extends DefaultBaseEntity> void copyNonNullField(T other, Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return;
        }
        if (field.getName().equals("id")) {
            return;
        }
        try {
            field.setAccessible(true);
            Object value = field.get(other);
            if (value != null) {
                field.set(this, value);
            }
        }
        catch (IllegalAccessException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

