/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.dao;

import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.MappedSuperclass;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.UUID;
import org.minijax.dao.Avatar;
import org.minijax.dao.DefaultBaseEntity;
import org.minijax.dao.NamedEntity;

@MappedSuperclass
public abstract class DefaultNamedEntity
extends DefaultBaseEntity
implements NamedEntity {
    private static final long serialVersionUID = 1L;
    public static final String HANDLE_SPECIAL_CHARS = "!#$%&'()*+,/:;=?@[\\]^`{|}~";
    public static final String HANDLE_SPECIAL_CHARS_REGEX = java.util.regex.Pattern.quote("!#$%&'()*+,/:;=?@[\\]^`{|}~");
    public static final String HANDLE_REGEX = "[^\\." + HANDLE_SPECIAL_CHARS_REGEX + "][^" + HANDLE_SPECIAL_CHARS_REGEX + "]*";
    @Column(length=32, unique=true)
    @Size(min=1, max=32)
    @Pattern(regexp="[^\\.\\Q!#$%&'()*+,/:;=?@[\\]^`{|}~\\E][^\\Q!#$%&'()*+,/:;=?@[\\]^`{|}~\\E]*")
    private @Size(min=1, max=32) @Pattern(regexp="[^\\.\\Q!#$%&'()*+,/:;=?@[\\]^`{|}~\\E][^\\Q!#$%&'()*+,/:;=?@[\\]^`{|}~\\E]*") String handle;
    @NotNull
    @Size(min=1, max=128)
    private @NotNull @Size(min=1, max=128) String name = "";
    @Embedded
    private Avatar avatar;

    protected DefaultNamedEntity() {
    }

    protected DefaultNamedEntity(String name) {
        this.setName(name);
    }

    @Override
    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle != null ? handle.trim() : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name != null ? name.trim() : "";
    }

    @Override
    public Avatar getAvatar() {
        return this.avatar;
    }

    @Override
    public void setAvatar(Avatar avatar) {
        this.avatar = avatar;
    }

    public void generateHandle() {
        String uuid = UUID.randomUUID().toString();
        this.handle = this.name == null ? uuid.substring(0, 16) : (this.name.replaceAll("[^A-Za-z0-9]", "") + "-" + uuid.substring(0, 6)).toLowerCase();
    }
}

