/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.data;

import java.io.Closeable;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.Validate;
import org.minijax.data.ConflictException;
import org.minijax.entity.BaseEntity;
import org.minijax.entity.NamedEntity;
import org.minijax.util.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDao
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseDao.class);
    protected EntityManager em;

    protected BaseDao(EntityManagerFactory emf) {
        this.em = emf.createEntityManager();
    }

    public <T extends BaseEntity> T create(T obj) {
        Validate.notNull(obj);
        Validate.isTrue((obj.getId() == null ? 1 : 0) != 0, (String)"ID must not be set before create", (Object[])new Object[0]);
        obj.validate();
        obj.setId(IdUtils.create());
        obj.setCreatedDateTime(Instant.now());
        obj.setUpdatedDateTime(obj.getCreatedDateTime());
        try {
            this.em.getTransaction().begin();
            this.em.persist(obj);
            this.em.flush();
            this.em.getTransaction().commit();
            return obj;
        }
        catch (PersistenceException ex) {
            throw BaseDao.convertRollbackToConflict(ex);
        }
    }

    public <T extends BaseEntity> T read(Class<T> entityClass, UUID id) {
        Validate.notNull(entityClass);
        Validate.notNull((Object)id);
        return (T)((BaseEntity)this.em.find(entityClass, (Object)id));
    }

    public <T extends NamedEntity> T readByHandle(Class<T> entityClass, String handle) {
        try {
            return (T)((NamedEntity)this.em.createQuery("SELECT e FROM " + entityClass.getSimpleName() + " e WHERE e.handle = :handle", entityClass).setParameter("handle", (Object)handle).getSingleResult());
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public <T extends BaseEntity> List<T> readPage(Class<T> entityClass, int page, int pageSize) {
        Validate.notNull(entityClass);
        Validate.inclusiveBetween((long)0L, (long)1000L, (long)page);
        Validate.inclusiveBetween((long)1L, (long)1000L, (long)pageSize);
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(entityClass);
        Root root = cq.from(entityClass);
        cq.select((Selection)root);
        cq.orderBy(new Order[]{cb.desc((Expression)root.get("id"))});
        return this.em.createQuery(cq).setFirstResult(page * pageSize).setMaxResults(pageSize).getResultList();
    }

    public <T extends BaseEntity> T update(T obj) {
        Validate.notNull(obj);
        Validate.notNull((Object)obj.getId());
        obj.validate();
        obj.setUpdatedDateTime(Instant.now());
        try {
            this.em.getTransaction().begin();
            this.em.merge(obj);
            this.em.flush();
            this.em.getTransaction().commit();
            return obj;
        }
        catch (PersistenceException ex) {
            throw BaseDao.convertRollbackToConflict(ex);
        }
    }

    public <T extends BaseEntity> void delete(T obj) {
        Validate.notNull(obj);
        Validate.notNull((Object)obj.getId());
        obj.setDeletedDateTime(Instant.now());
        this.update(obj);
    }

    public <T extends BaseEntity> void purge(T obj) {
        Validate.notNull(obj);
        Validate.notNull((Object)obj.getId());
        BaseEntity actual = (BaseEntity)this.em.find(obj.getClass(), (Object)obj.getId());
        if (actual != null) {
            this.em.getTransaction().begin();
            this.em.remove((Object)actual);
            this.em.getTransaction().commit();
        }
    }

    public <T extends BaseEntity> long countAll(Class<T> entityClass) {
        Validate.notNull(entityClass);
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        return (Long)this.em.createQuery(cq.select((Selection)cb.count((Expression)cq.from(entityClass)))).getSingleResult();
    }

    @Override
    public void close() {
        this.em.close();
    }

    protected static <T extends BaseEntity> T firstOrNull(List<T> list) {
        return (T)(list.isEmpty() ? null : (BaseEntity)list.get(0));
    }

    static ConflictException convertRollbackToConflict(PersistenceException ex) {
        List<Pattern> patterns = Arrays.asList(Pattern.compile("Duplicate entry '(?<value>[^']+)' for key '(?<key>[^']+)'"), Pattern.compile("CONSTRAINT_INDEX_[a-zA-Z0-9_]+ ON PUBLIC\\.[a-zA-Z]+\\((?<key>[a-zA-Z]+)\\) VALUES \\('(?<value>[^']+)'"));
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(ex.getMessage());
            if (!matcher.find()) continue;
            String key = matcher.group("key").toLowerCase();
            String value = matcher.group("value");
            return new ConflictException(key, value);
        }
        LOG.warn("Unrecognized RollbackException: {}", (Object)ex.getMessage(), (Object)ex);
        throw ex;
    }
}

