/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.eclipselink;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import javax.sql.DataSource;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Session;

public class EclipselinkSessionCustomizer
implements SessionCustomizer {
    public void customize(Session session) {
        EclipselinkSessionCustomizer.setupDataSource(session);
    }

    private static void setupDataSource(Session session) {
        DatabaseLogin login = session.getLogin();
        Map props = session.getProperties();
        String url = (String)props.get("org.minijax.db.url");
        if (url == null) {
            return;
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(url);
        config.setDriverClassName((String)props.get("org.minijax.db.driver"));
        config.setUsername((String)props.get("org.minijax.db.username"));
        config.setPassword((String)props.get("org.minijax.db.password"));
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        config.addDataSourceProperty("useServerPrepStmts", (Object)"true");
        config.addDataSourceProperty("useLocalSessionState", (Object)"true");
        config.addDataSourceProperty("useLocalTransactionState", (Object)"true");
        config.addDataSourceProperty("rewriteBatchedStatements", (Object)"true");
        config.addDataSourceProperty("cacheResultSetMetadata", (Object)"true");
        config.addDataSourceProperty("cacheServerConfiguration", (Object)"true");
        config.addDataSourceProperty("elideSetAutoCommits", (Object)"true");
        config.addDataSourceProperty("maintainTimeStats", (Object)"false");
        login.setConnector((Connector)new JNDIConnector((DataSource)new HikariDataSource(config)));
        login.useExternalConnectionPooling();
    }
}

