/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.jndi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.minijax.jndi.MinijaxBindingsEnumeration;
import org.minijax.jndi.MinijaxNameClassPairEnumeration;
import org.minijax.jndi.MinijaxNameParser;

public class MinijaxContext
implements Context {
    private final Properties env = new Properties();
    private final MinijaxNameParser nameParser;
    private final Map<Name, Object> namesToObjects;
    private final Map<Name, MinijaxContext> subContexts;

    public MinijaxContext(Map<Object, Object> env, boolean root) throws NamingException {
        this.env.putAll(env);
        this.nameParser = new MinijaxNameParser(this);
        this.namesToObjects = Collections.synchronizedMap(new HashMap());
        this.subContexts = Collections.synchronizedMap(new HashMap());
        if (root) {
            this.createSubcontext("java:comp");
            this.createSubcontext("java:comp/env");
            this.createSubcontext("java:comp/env/ejb");
        }
    }

    private MinijaxContext(MinijaxContext other) throws NamingException {
        this(other.env, false);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.env;
    }

    @Override
    public MinijaxContext createSubcontext(Name name) throws NamingException {
        if (name.size() > 1) {
            if (!this.subContexts.containsKey(name.getPrefix(1))) {
                throw new NameNotFoundException("Subcontext '" + name.getPrefix(1) + "' not found");
            }
            return this.subContexts.get(name.getPrefix(1)).createSubcontext(name.getSuffix(1));
        }
        MinijaxContext newContext = new MinijaxContext(this.env, false);
        this.bind(name, (Object)newContext);
        return newContext;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.nameParser.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (name.size() > 1) {
            if (this.subContexts.containsKey(name.getPrefix(1))) {
                Context subContext = this.subContexts.get(name.getPrefix(1));
                this.destroySubcontexts(subContext);
                return;
            }
            throw new NameNotFoundException();
        }
        if (this.namesToObjects.containsKey(name)) {
            throw new NotContextException();
        }
        if (!this.subContexts.containsKey(name)) {
            throw new NameNotFoundException();
        }
        Context subContext = this.subContexts.get(name);
        this.destroySubcontexts(subContext);
        subContext.close();
        this.subContexts.remove(name);
    }

    private void destroySubcontexts(Context context) throws NamingException {
        NamingEnumeration<Binding> bindings = context.listBindings("");
        while (bindings.hasMore()) {
            Binding binding = bindings.next();
            String name = binding.getName();
            if (binding.getObject() instanceof Context) {
                Context subContext = (Context)binding.getObject();
                this.destroySubcontexts(subContext);
                context.destroySubcontext(name);
                continue;
            }
            context.unbind(name);
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.nameParser.parse(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name.size() == 0) {
            return new MinijaxContext(this);
        }
        Name objName = name.getPrefix(1);
        if (name.size() > 1) {
            if (this.subContexts.containsKey(objName)) {
                return this.subContexts.get(objName).lookup(name.getSuffix(1));
            }
            throw new NamingException("Invalid subcontext '" + name + "' in context '" + objName + "'");
        }
        if (this.namesToObjects.containsKey(name)) {
            return this.namesToObjects.get(objName);
        }
        if (this.subContexts.containsKey(name)) {
            return this.subContexts.get(name);
        }
        throw new NameNotFoundException(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.nameParser.parse(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Cannot bind to an empty name.");
        }
        if (name.size() > 1) {
            Name prefix = name.getPrefix(1);
            if (this.subContexts.containsKey(prefix)) {
                this.subContexts.get(prefix).bind(name.getSuffix(1), obj);
            } else {
                throw new NameNotFoundException(prefix.toString());
            }
        }
        if (this.namesToObjects.containsKey(name) || this.subContexts.containsKey(name)) {
            throw new NameAlreadyBoundException("Name " + name + " already bound.  Use rebind() to override");
        }
        if (obj instanceof MinijaxContext) {
            this.subContexts.put(name, (MinijaxContext)obj);
        } else {
            this.namesToObjects.put(name, obj);
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(this.nameParser.parse(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind to empty name");
        }
        if (name.size() == 1) {
            this.namesToObjects.remove(name);
            this.subContexts.remove(name);
            return;
        }
        Object targetContext = this.lookup(name.getPrefix(name.size() - 1));
        if (!(targetContext instanceof Context)) {
            throw new NamingException("Cannot unbind object.");
        }
        ((Context)targetContext).unbind(name.getSuffix(name.size() - 1));
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this.nameParser.parse(name));
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind to empty name");
        }
        Object targetContext = this.lookup(name.getPrefix(name.size() - 1));
        if (!(targetContext instanceof Context)) {
            throw new NamingException("Cannot bind object.  Target context does not exist.");
        }
        this.unbind(name);
        this.bind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this.nameParser.parse(name), obj);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (name == null || name.isEmpty()) {
            HashMap<Object, Object> enumStore = new HashMap<Object, Object>();
            enumStore.putAll(this.namesToObjects);
            enumStore.putAll(this.subContexts);
            return new MinijaxNameClassPairEnumeration(enumStore);
        }
        Name subName = name.getPrefix(1);
        if (this.namesToObjects.containsKey(subName)) {
            throw new NotContextException(name + " cannot be listed");
        }
        if (this.subContexts.containsKey(subName)) {
            return this.subContexts.get(subName).list(name.getSuffix(1));
        }
        throw new NamingException();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(this.nameParser.parse(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (name == null || name.isEmpty()) {
            HashMap<Object, Object> enumStore = new HashMap<Object, Object>();
            enumStore.putAll(this.namesToObjects);
            enumStore.putAll(this.subContexts);
            return new MinijaxBindingsEnumeration(enumStore);
        }
        Name subName = name.getPrefix(1);
        if (this.subContexts.containsKey(subName)) {
            return this.subContexts.get(subName).listBindings(name.getSuffix(1));
        }
        throw new NamingException("AbstractContext#listBindings(\"" + name + "\"): subcontext not found.");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(this.nameParser.parse(name));
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new UnsupportedOperationException();
    }
}

