/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;

@Singleton
@Consumes(value={"application/json"})
public class MinijaxJsonReader
implements MessageBodyReader<Object> {
    @Inject
    private ObjectMapper objectMapper;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return this.objectMapper.readValue(entityStream, type);
        }
        catch (JsonProcessingException ex) {
            throw new BadRequestException(ex.getMessage(), (Throwable)ex);
        }
    }
}

