/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Singleton;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.minijax.json.Json;

@Singleton
@Consumes(value={"application/json"})
public class MinijaxJsonReader
implements MessageBodyReader<Object> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ObjectMapper objectMapper = Json.getObjectMapper();
        try {
            if (genericType != null) {
                return objectMapper.readValue(entityStream, objectMapper.getTypeFactory().constructType(genericType));
            }
            return objectMapper.readValue(entityStream, type);
        }
        catch (JsonProcessingException ex) {
            throw new BadRequestException(ex.getMessage(), (Throwable)ex);
        }
    }
}

