/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.json;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.config.PropertyVisibilityStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Json {
    private static Jsonb instance;

    Json() {
        throw new UnsupportedOperationException();
    }

    public static JsonbConfig getDefaultConfig() {
        PropertyVisibilityStrategy visibility = new PropertyVisibilityStrategy(){

            public boolean isVisible(Field field) {
                return true;
            }

            public boolean isVisible(Method method) {
                return method.getAnnotation(JsonbProperty.class) != null;
            }
        };
        return new JsonbConfig().withPropertyVisibilityStrategy(visibility).withPropertyOrderStrategy("LEXICOGRAPHICAL");
    }

    public static void initObjectMapper(JsonbConfig config) {
        if (instance != null) {
            throw new IllegalStateException("JSON object mapper already created");
        }
        instance = JsonbBuilder.create((JsonbConfig)config);
    }

    public static Jsonb getObjectMapper() {
        if (instance == null) {
            Json.initObjectMapper(Json.getDefaultConfig());
        }
        return instance;
    }
}

