/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.json;

import jakarta.inject.Singleton;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbException;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.minijax.json.Json;

@Singleton
@Consumes(value={"application/json"})
public class MinijaxJsonReader
implements MessageBodyReader<Object> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        Jsonb objectMapper = Json.getObjectMapper();
        try {
            if (genericType != null) {
                return objectMapper.fromJson(entityStream, genericType);
            }
            return objectMapper.fromJson(entityStream, type);
        }
        catch (JsonbException ex) {
            throw new BadRequestException(ex.getMessage(), (Throwable)ex);
        }
    }
}

