/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.liquibase;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.change.Change;
import liquibase.change.core.DropTableChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.core.xml.XMLChangeLogSerializer;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LiquibaseHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LiquibaseHelper.class);
    private static final String DEFAULT_RESOURCES_DIR = "src/main/resources";
    private static final String DEFAULT_CHANGELOG_RESOURCE_NAME = "changelog.xml";
    private final String persistenceUnitName;
    private final String driver;
    private final String url;
    private final String username;
    private final String password;
    private final String referenceUrl;
    private final ResourceAccessor resourceAccessor;
    private final File resourcesDir;
    private final String changeLogResourceName;

    public LiquibaseHelper(Map<String, String> props) {
        this(props, (ResourceAccessor)new ClassLoaderResourceAccessor(), new File(DEFAULT_RESOURCES_DIR), DEFAULT_CHANGELOG_RESOURCE_NAME);
    }

    LiquibaseHelper(Map<String, String> props, ResourceAccessor resourceAccessor, File resourcesDir, String changeLogResourceName) {
        this.persistenceUnitName = props.get("org.minijax.data.persistenceUnitName");
        this.driver = props.get("org.minijax.data.driver");
        this.url = props.get("org.minijax.data.url");
        this.username = props.get("org.minijax.data.username");
        this.password = props.get("org.minijax.data.password");
        this.referenceUrl = props.get("org.minijax.data.referenceUrl");
        this.resourceAccessor = resourceAccessor;
        this.resourcesDir = resourcesDir;
        this.changeLogResourceName = changeLogResourceName;
    }

    public File getResourcesDir() {
        return this.resourcesDir;
    }

    public String getChangeLogResourceName() {
        return this.changeLogResourceName;
    }

    public void migrate() throws LiquibaseException, SQLException {
        Database database = null;
        try {
            database = this.getTargetDatabase();
            Liquibase liquibase = new Liquibase(this.changeLogResourceName, this.resourceAccessor, database);
            liquibase.update("");
        }
        finally {
            LiquibaseHelper.closeQuietly(database);
        }
    }

    public void generateMigrations() throws IOException, LiquibaseException, SQLException {
        Database referenceDatabase = null;
        Database targetDatabase = null;
        try {
            referenceDatabase = this.getReferenceDatabase();
            targetDatabase = this.getTargetDatabase();
            this.generateMigrations(referenceDatabase, targetDatabase);
        }
        finally {
            LiquibaseHelper.closeQuietly(referenceDatabase);
            LiquibaseHelper.closeQuietly(targetDatabase);
        }
    }

    protected Connection getConnection(String url, String username, String password) throws SQLException {
        return DriverManager.getConnection(url, username, password);
    }

    protected Database getLiquibaseDatabase(Connection conn) throws DatabaseException {
        return DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(conn));
    }

    private Database getTargetDatabase() throws DatabaseException, SQLException {
        return this.getLiquibaseDatabase(this.getConnection(this.url, this.username, this.password));
    }

    public Database getReferenceDatabase() throws DatabaseException, SQLException {
        this.buildReferenceDatabase();
        return this.getLiquibaseDatabase(this.getConnection(this.referenceUrl, this.username, this.password));
    }

    private void buildReferenceDatabase() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.persistence.jdbc.driver", this.driver);
        props.put("javax.persistence.jdbc.url", this.referenceUrl);
        props.put("javax.persistence.jdbc.user", this.username);
        props.put("javax.persistence.jdbc.password", this.password);
        props.put("javax.persistence.schema-generation.database.action", "drop-and-create");
        EntityManagerFactory emf = null;
        try {
            emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, props);
        }
        catch (Throwable throwable) {
            LiquibaseHelper.closeQuietly(emf);
            throw throwable;
        }
        LiquibaseHelper.closeQuietly(emf);
    }

    private void generateMigrations(Database referenceDatabase, Database targetDatabase) throws LiquibaseException, IOException {
        File changeLogFile;
        if (!this.resourcesDir.exists()) {
            this.resourcesDir.mkdirs();
        }
        if ((changeLogFile = new File(this.resourcesDir, this.changeLogResourceName)).exists()) {
            LOG.info("Checking current database state");
            this.validateDatabaseState(targetDatabase);
        }
        SnapshotControl snapshotControl = new SnapshotControl(referenceDatabase, new Class[]{Schema.class, Table.class, Column.class, PrimaryKey.class, Index.class});
        LOG.info("Executing diff");
        CompareControl compareControl = new CompareControl(snapshotControl.getTypesToInclude());
        DiffResult diffResult = DiffGeneratorFactory.getInstance().compare(referenceDatabase, targetDatabase, compareControl);
        LOG.info("Converting diff to changelog");
        DiffOutputControl diffOutputControl = new DiffOutputControl(false, false, true, null);
        DiffToChangeLog diffToChangeLog = new DiffToChangeLog(diffResult, diffOutputControl);
        diffToChangeLog.setChangeSetAuthor(LiquibaseHelper.getAuthor(System.getProperty("user.name")));
        LOG.info("Reading existing changelog");
        ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser(this.changeLogResourceName, this.resourceAccessor);
        ChangeLogParameters changeLogParameters = null;
        DatabaseChangeLog existingChangeLog = null;
        try {
            existingChangeLog = parser.parse(this.changeLogResourceName, changeLogParameters, this.resourceAccessor);
        }
        catch (ChangeLogParseException ex) {
            existingChangeLog = new DatabaseChangeLog();
        }
        LOG.info("Adding new entries to changelog");
        for (ChangeSet changeSet : diffToChangeLog.generateChangeSets()) {
            if (LiquibaseHelper.isIgnoredChangeSet(changeSet)) continue;
            existingChangeLog.addChangeSet(changeSet);
        }
        LOG.info("Writing the changelog to disk");
        List changeSets = existingChangeLog.getChangeSets();
        try (FileOutputStream outputStream = new FileOutputStream(changeLogFile);){
            XMLChangeLogSerializer changeLogSerializer = new XMLChangeLogSerializer();
            changeLogSerializer.write(changeSets, (OutputStream)outputStream);
            outputStream.flush();
        }
        LOG.info("Cleaning changelog");
        LiquibaseHelper.removeObjectQuotingStrategy(changeLogFile);
        LOG.info("Diff complete");
    }

    private void validateDatabaseState(Database database) throws LiquibaseException {
        Liquibase liquibase = new Liquibase(this.changeLogResourceName, this.resourceAccessor, database);
        Contexts contexts = new Contexts();
        LabelExpression labels = new LabelExpression();
        List unrunChangeSets = liquibase.listUnrunChangeSets(contexts, labels);
        Validate.isTrue((boolean)unrunChangeSets.isEmpty(), (String)"Unrun change sets!  Please migrate the database first", (Object[])new Object[0]);
    }

    public static String getAuthor(String userName) {
        if (userName == null || userName.trim().isEmpty()) {
            return null;
        }
        return StringUtils.capitalize((String)userName.trim());
    }

    public static boolean isIgnoredChangeSet(ChangeSet changeSet) {
        List changes = changeSet.getChanges();
        if (changes.size() != 1) {
            return false;
        }
        Change change = (Change)changes.get(0);
        if (!(change instanceof DropTableChange)) {
            return false;
        }
        return ((DropTableChange)change).getTableName().equals("JGROUPSPING");
    }

    static void closeQuietly(EntityManagerFactory emf) {
        if (emf != null) {
            try {
                emf.close();
            }
            catch (Exception ex) {
                LOG.warn("Error closing entity manager factory: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    static void closeQuietly(Database database) {
        if (database != null) {
            try {
                database.close();
            }
            catch (Exception ex) {
                LOG.warn("Error closing database: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    public static void removeObjectQuotingStrategy(File changeLogFile) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document doc = factory.newDocumentBuilder().parse(changeLogFile);
            XPathExpression expr = XPathFactory.newInstance().newXPath().compile("//@objectQuotingStrategy");
            NodeList nodes = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Attr attr = (Attr)nodes.item(i);
                if (!attr.getNodeName().equals("objectQuotingStrategy")) continue;
                Element el = attr.getOwnerElement();
                el.removeAttribute(attr.getNodeName());
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(changeLogFile));
        }
        catch (ParserConfigurationException | TransformerException | XPathException | SAXException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }
}

