/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.liquibase;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.change.Change;
import liquibase.change.core.DropTableChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.core.xml.XMLChangeLogSerializer;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LiquibaseHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LiquibaseHelper.class);
    private static final File DEFAULT_RESOURCES_DIR = new File("src/main/resources");
    private static final String MIGRATIONS_DIR = "migrations";
    private static final String MASTER_CHANGELOG_RESOURCE_NAME = "master.changelog.xml";
    private static final String XML_FACTORY = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private final String persistenceUnitName;
    private final String driver;
    private final String url;
    private final String username;
    private final String password;
    private final String referenceUrl;
    private final ResourceAccessor resourceAccessor;
    private final File resourcesDir;
    private final File migrationsDir;
    private final File masterChangeLogFile;

    public LiquibaseHelper(Map<String, String> props) {
        this(props, (ResourceAccessor)new ClassLoaderResourceAccessor(), DEFAULT_RESOURCES_DIR, MASTER_CHANGELOG_RESOURCE_NAME);
    }

    LiquibaseHelper(Map<String, String> props, ResourceAccessor resourceAccessor, File resourcesDir, String masterChangeLogName) {
        this.resourceAccessor = resourceAccessor;
        this.resourcesDir = resourcesDir;
        this.persistenceUnitName = props.get("org.minijax.db.persistenceUnitName");
        this.driver = props.get("javax.persistence.jdbc.driver");
        this.url = props.get("javax.persistence.jdbc.url");
        this.username = props.get("javax.persistence.jdbc.user");
        this.password = props.get("javax.persistence.jdbc.password");
        this.referenceUrl = props.get("org.minijax.db.referenceUrl");
        this.migrationsDir = new File(resourcesDir, MIGRATIONS_DIR);
        this.masterChangeLogFile = new File(this.migrationsDir, masterChangeLogName);
    }

    public File getResourcesDir() {
        return this.resourcesDir;
    }

    public File getMasterChangeLogFile() {
        return this.masterChangeLogFile;
    }

    public void migrate() throws LiquibaseException, SQLException {
        Database database = null;
        try {
            database = this.getTargetDatabase();
            this.getLiquibase(database).update("");
        }
        finally {
            LiquibaseHelper.closeQuietly(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateMigrations() throws IOException, LiquibaseException, SQLException {
        Database referenceDatabase = null;
        Database targetDatabase = null;
        try {
            referenceDatabase = this.getReferenceDatabase();
            targetDatabase = this.getTargetDatabase();
            File file = this.generateMigrations(referenceDatabase, targetDatabase);
            return file;
        }
        finally {
            LiquibaseHelper.closeQuietly(referenceDatabase);
            LiquibaseHelper.closeQuietly(targetDatabase);
        }
    }

    private Liquibase getLiquibase(Database targetDatabase) throws LiquibaseException {
        return new Liquibase(this.getRelativePath(this.masterChangeLogFile), this.resourceAccessor, targetDatabase);
    }

    private String getRelativePath(File resourceFile) {
        return this.resourcesDir.toPath().relativize(resourceFile.toPath()).toString();
    }

    private Connection getConnection(String url, String username, String password) throws SQLException {
        return DriverManager.getConnection(url, username, password);
    }

    private Database getLiquibaseDatabase(Connection conn) throws DatabaseException {
        return DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(conn));
    }

    private Database getTargetDatabase() throws LiquibaseException, SQLException {
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException ex) {
            throw new LiquibaseException(ex.getMessage(), (Throwable)ex);
        }
        return this.getLiquibaseDatabase(this.getConnection(this.url, this.username, this.password));
    }

    private Database getReferenceDatabase() throws DatabaseException, SQLException {
        this.buildReferenceDatabase();
        return this.getLiquibaseDatabase(this.getConnection(this.referenceUrl, this.username, this.password));
    }

    private void buildReferenceDatabase() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.persistence.jdbc.driver", this.driver);
        props.put("javax.persistence.jdbc.url", this.referenceUrl);
        props.put("javax.persistence.jdbc.user", this.username);
        props.put("javax.persistence.jdbc.password", this.password);
        props.put("javax.persistence.schema-generation.database.action", "drop-and-create");
        EntityManagerFactory emf = null;
        try {
            emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, props);
        }
        catch (Throwable throwable) {
            LiquibaseHelper.closeQuietly(emf);
            throw throwable;
        }
        LiquibaseHelper.closeQuietly(emf);
    }

    private File generateMigrations(Database referenceDatabase, Database targetDatabase) throws LiquibaseException, IOException {
        if (!this.resourcesDir.exists()) {
            this.resourcesDir.mkdirs();
        }
        if (!this.migrationsDir.exists()) {
            this.migrationsDir.mkdirs();
        }
        if (this.masterChangeLogFile.exists()) {
            LOG.info("Checking current database state");
            this.validateDatabaseState(targetDatabase);
        } else {
            LOG.info("Creating new master changelog");
            this.writeChangeSets(this.masterChangeLogFile, Collections.emptyList());
        }
        SnapshotControl snapshotControl = new SnapshotControl(referenceDatabase, new Class[]{Schema.class, Table.class, Column.class, PrimaryKey.class, Index.class});
        LOG.info("Executing diff");
        CompareControl compareControl = new CompareControl(snapshotControl.getTypesToInclude());
        DiffResult diffResult = DiffGeneratorFactory.getInstance().compare(referenceDatabase, targetDatabase, compareControl);
        LOG.info("Converting diff to changelog");
        DiffOutputControl diffOutputControl = new DiffOutputControl(false, false, true, null);
        DiffToChangeLog diffToChangeLog = new DiffToChangeLog(diffResult, diffOutputControl);
        diffToChangeLog.setChangeSetAuthor(System.getProperty("user.name"));
        List<ChangeSet> changeSets = LiquibaseHelper.filterChangeSets(diffToChangeLog.generateChangeSets());
        LOG.info("Found {} changes", (Object)changeSets.size());
        if (changeSets.isEmpty()) {
            return null;
        }
        File generatedChangeLogFile = new File(this.migrationsDir, LiquibaseHelper.generateFileName(this.masterChangeLogFile));
        LOG.info("Writing new changelog: {}", (Object)generatedChangeLogFile);
        this.writeChangeSets(generatedChangeLogFile, changeSets);
        LOG.info("Add migration to master changelog: {}", (Object)this.masterChangeLogFile);
        this.addIncludeFile(generatedChangeLogFile);
        LOG.info("Cleaning changelog");
        LiquibaseHelper.cleanXmlFile(this.masterChangeLogFile);
        LiquibaseHelper.cleanXmlFile(generatedChangeLogFile);
        LOG.info("Diff complete");
        return generatedChangeLogFile;
    }

    private void validateDatabaseState(Database database) throws LiquibaseException {
        LabelExpression labels;
        Contexts contexts;
        Liquibase liquibase = this.getLiquibase(database);
        List unrunChangeSets = liquibase.listUnrunChangeSets(contexts = new Contexts(), labels = new LabelExpression());
        if (!unrunChangeSets.isEmpty()) {
            throw new IllegalStateException("Unrun change sets!  Please migrate the database first");
        }
    }

    static List<ChangeSet> filterChangeSets(List<ChangeSet> changeSets) {
        ArrayList<ChangeSet> result = new ArrayList<ChangeSet>();
        for (ChangeSet changeSet : changeSets) {
            if (LiquibaseHelper.isIgnoredChangeSet(changeSet)) continue;
            result.add(changeSet);
        }
        return result;
    }

    static boolean isIgnoredChangeSet(ChangeSet changeSet) {
        List changes = changeSet.getChanges();
        if (changes.size() != 1) {
            return false;
        }
        Change change = (Change)changes.get(0);
        if (!(change instanceof DropTableChange)) {
            return false;
        }
        return ((DropTableChange)change).getTableName().equals("JGROUPSPING");
    }

    static void closeQuietly(EntityManagerFactory emf) {
        if (emf != null) {
            try {
                emf.close();
            }
            catch (Exception ex) {
                LOG.warn("Error closing entity manager factory: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    static void closeQuietly(Database database) {
        if (database != null) {
            try {
                database.close();
            }
            catch (Exception ex) {
                LOG.warn("Error closing database: {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    private void writeChangeSets(File file, List<ChangeSet> changeSets) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            XMLChangeLogSerializer changeLogSerializer = new XMLChangeLogSerializer();
            changeLogSerializer.write(changeSets, (OutputStream)outputStream);
            outputStream.flush();
        }
    }

    private void addIncludeFile(File includeFile) throws IOException {
        Document doc = LiquibaseHelper.readXml(this.masterChangeLogFile);
        Element include = doc.createElement("include");
        include.setAttribute("file", this.getRelativePath(includeFile));
        doc.getDocumentElement().appendChild(include);
        LiquibaseHelper.writeXml(doc, this.masterChangeLogFile);
    }

    private static void cleanXmlFile(File file) throws IOException {
        try {
            Document doc = LiquibaseHelper.readXml(file);
            XPath xpath = XPathFactory.newInstance().newXPath();
            LiquibaseHelper.removeNodes(doc, xpath, "//@objectQuotingStrategy");
            LiquibaseHelper.removeNodes(doc, xpath, "//text()[normalize-space()='']");
            LiquibaseHelper.writeXml(doc, file);
        }
        catch (XPathException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private static Document readXml(File file) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            return factory.newDocumentBuilder().parse(file);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private static void writeXml(Document doc, File file) throws IOException {
        doc.normalize();
        TransformerFactory transformerFactory = TransformerFactory.newInstance(XML_FACTORY, null);
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(doc), new StreamResult(file));
        }
        catch (TransformerException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private static void removeNodes(Document doc, XPath xpath, String expression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xpath.evaluate(expression, doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Attr) {
                Attr attr = (Attr)node;
                attr.getOwnerElement().removeAttribute(attr.getNodeName());
                continue;
            }
            node.getParentNode().removeChild(node);
        }
    }

    private static String generateFileName(File masterChangeLogFile) throws IOException {
        int id = LiquibaseHelper.readXml(masterChangeLogFile).getDocumentElement().getElementsByTagName("include").getLength() + 1;
        return String.format("changelog.%04d.xml", id);
    }
}

