/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Set;
import org.minijax.nio.Worker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Listener
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Listener.class);
    private final SelectorProvider selectorProvider;
    private final int port;
    private volatile boolean running;
    private Worker currentWorker;

    public Listener(SelectorProvider selectorProvider, int port) {
        this.selectorProvider = selectorProvider;
        this.port = port;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public Worker getCurrentWorker() {
        return this.currentWorker;
    }

    public void setCurrentWorker(Worker currentWorker) {
        this.currentWorker = currentWorker;
    }

    @Override
    public void run() {
        LOG.info("Starting listener...");
        this.running = true;
        LOG.info("Creating server channel...");
        try (ServerSocketChannel serverChannel = this.selectorProvider.openServerSocketChannel();){
            serverChannel.configureBlocking(false);
            LOG.info("Creating server socket...");
            ServerSocket serverSocket = serverChannel.socket();
            serverSocket.setReceiveBufferSize(16384);
            serverSocket.setReuseAddress(true);
            serverSocket.bind(new InetSocketAddress(this.port), 16384);
            LOG.info("Registering server...");
            AbstractSelector selector = this.selectorProvider.openSelector();
            serverChannel.register(selector, 16);
            while (this.running) {
                if (selector.select(20L) == 0) continue;
                Set<SelectionKey> selectedKeys = selector.selectedKeys();
                Iterator<SelectionKey> iter = selectedKeys.iterator();
                while (iter.hasNext()) {
                    iter.next();
                    iter.remove();
                    SocketChannel channel = serverChannel.accept();
                    LOG.debug("Listener accepted {}", (Object)channel);
                    this.currentWorker.accept(channel);
                    this.currentWorker = this.currentWorker.getNextWorker();
                }
            }
        }
        catch (IOException ex) {
            LOG.warn("Exception in listener thread: {}", (Object)ex.getMessage(), (Object)ex);
        }
        LOG.info("Listener done.");
    }
}

