/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.nio;

import java.io.IOException;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.minijax.Minijax;
import org.minijax.nio.DateHeader;
import org.minijax.nio.Listener;
import org.minijax.nio.Worker;
import org.minijax.rs.MinijaxServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinijaxNioServer
implements MinijaxServer {
    private static final Logger LOG = LoggerFactory.getLogger(MinijaxNioServer.class);
    final ExecutorService executorService;
    final Listener listener;
    final Worker[] workers;

    public MinijaxNioServer(Minijax minijax) throws IOException {
        this(minijax, SelectorProvider.provider());
    }

    MinijaxNioServer(Minijax minijax, SelectorProvider selectorProvider) throws IOException {
        int i;
        int threadCount = Runtime.getRuntime().availableProcessors() * 2;
        int workerCount = threadCount - 2;
        LOG.info("Thread count: {}", (Object)threadCount);
        this.executorService = Executors.newFixedThreadPool(threadCount);
        DateHeader.start();
        this.listener = new Listener(selectorProvider, minijax.getPort());
        this.workers = new Worker[workerCount];
        for (i = 0; i < workerCount; ++i) {
            this.workers[i] = new Worker(minijax, selectorProvider);
        }
        for (i = 0; i < workerCount; ++i) {
            this.workers[i].setNextWorker(this.workers[(i + 1) % workerCount]);
        }
        this.listener.setCurrentWorker(this.workers[0]);
    }

    public void start() {
        for (Worker worker : this.workers) {
            this.executorService.execute(worker);
        }
        this.executorService.execute(this.listener);
    }

    public void stop() {
        LOG.info("Stopping listener...");
        this.listener.setRunning(false);
        LOG.info("Stopping workers...");
        for (Worker worker : this.workers) {
            worker.setRunning(false);
        }
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            LOG.warn("Termination interrupted: {}", (Object)ex.getMessage(), (Object)ex);
            Thread.currentThread().interrupt();
        }
        DateHeader.stop();
    }
}

