/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.nio;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.List;
import java.util.Map;
import org.minijax.Minijax;
import org.minijax.commons.MinijaxException;
import org.minijax.nio.DateHeader;
import org.minijax.nio.MinijaxNioHttpHeaders;
import org.minijax.nio.MinijaxNioRequestContext;
import org.minijax.rs.MinijaxApplication;
import org.minijax.rs.MinijaxProviders;
import org.minijax.rs.MinijaxRequestContext;
import org.minijax.rs.MinijaxUriInfo;
import org.minijax.rs.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connection {
    private static final Logger LOG = LoggerFactory.getLogger(Connection.class);
    private static final byte[] HTTP_PREFIX = "HTTP/".getBytes();
    private static final byte[] DATE_HEADER = "Date: ".getBytes();
    private static final byte[] CONTENT_TYPE_HEADER = "Content-Type: ".getBytes();
    private static final byte[] CONTENT_LENGTH_HEADER = "Content-Length: ".getBytes();
    private static final byte[] CRLF = "\r\n".getBytes();
    private final Minijax minijax;
    private final ByteChannel channel;
    private final ByteBuffer buffer;
    private URI uri;
    private String method;
    private String protocol;
    private String version;
    private boolean onlyHeader;
    private boolean keepAlive;
    private MultivaluedMap<String, String> requestHeaders;
    private InputStream requestEntityStream;
    private Response response;
    private ByteArrayOutputStream bufferedOutputStream;

    public Connection(Minijax minijax, ByteChannel channel, ByteBuffer buffer) {
        this.minijax = minijax;
        this.channel = channel;
        this.buffer = buffer;
    }

    Connection(Minijax minijax, ByteChannel channel) {
        this(minijax, channel, ByteBuffer.allocate(1000));
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public boolean handle() throws IOException {
        if (!this.read()) {
            return false;
        }
        this.process();
        return this.write();
    }

    private boolean read() {
        this.buffer.clear();
        try {
            this.channel.read(this.buffer);
        }
        catch (IOException ex) {
            LOG.debug("Read exception: {}", (Object)ex.getMessage(), (Object)ex);
            return false;
        }
        this.buffer.flip();
        String requestLine = this.readLine();
        if (requestLine == null) {
            return false;
        }
        int index1 = requestLine.indexOf(32);
        int index2 = requestLine.indexOf(32, index1 + 1);
        int index3 = requestLine.indexOf(47, index2 + 1);
        if (index1 < 0 || index2 < 0 || index3 < 0) {
            return false;
        }
        this.method = requestLine.substring(0, index1);
        this.uri = URI.create(requestLine.substring(index1 + 1, index2));
        this.protocol = requestLine.substring(index2 + 1, index3);
        this.version = requestLine.substring(index3 + 1);
        LOG.debug("{} {} {} {}", new Object[]{this.method, this.uri, this.protocol, this.version});
        if (!this.version.equals("1.0") && !this.version.equals("1.1")) {
            return false;
        }
        this.requestHeaders = this.readHeaders();
        this.requestEntityStream = this.readContentBody();
        this.onlyHeader = this.method.equals("HEAD");
        this.keepAlive = this.shouldKeepAlive();
        return true;
    }

    private void process() throws IOException {
        MinijaxApplication application = this.minijax.getDefaultApplication();
        try (MinijaxNioRequestContext ctx = new MinijaxNioRequestContext(application, this.method, new MinijaxUriInfo(this.uri), new MinijaxNioHttpHeaders(this.requestHeaders), this.requestEntityStream);){
            this.response = application.handle((MinijaxRequestContext)ctx);
            if (this.onlyHeader) {
                this.bufferedOutputStream = null;
            } else {
                this.bufferedOutputStream = new ByteArrayOutputStream();
                EntityUtils.writeEntity((Object)this.response.getEntity(), (MediaType)this.response.getMediaType(), (MinijaxProviders)ctx.getProviders(), (OutputStream)this.bufferedOutputStream);
            }
        }
    }

    private boolean write() throws IOException {
        this.buffer.clear();
        this.buffer.put(HTTP_PREFIX);
        this.buffer.put(this.version.getBytes());
        this.buffer.put((byte)32);
        this.buffer.put(Integer.toString(this.response.getStatus()).getBytes());
        this.buffer.put(CRLF);
        this.buffer.put(DATE_HEADER);
        this.buffer.put(DateHeader.get());
        this.buffer.put(CRLF);
        MediaType mediaType = this.response.getMediaType();
        if (mediaType != null) {
            this.buffer.put(CONTENT_TYPE_HEADER);
            this.buffer.put(mediaType.toString().getBytes());
            this.buffer.put(CRLF);
        }
        if (this.bufferedOutputStream != null) {
            this.buffer.put(CONTENT_LENGTH_HEADER);
            this.buffer.put(Integer.toString(this.bufferedOutputStream.size()).getBytes());
            this.buffer.put(CRLF);
        }
        for (Map.Entry entry : this.response.getHeaders().entrySet()) {
            byte[] keyBytes = ((String)entry.getKey()).getBytes();
            for (Object value : (List)entry.getValue()) {
                if (value == null) continue;
                this.buffer.put(keyBytes);
                this.buffer.put(": ".getBytes());
                this.buffer.put(value.toString().getBytes());
                this.buffer.put(CRLF);
            }
        }
        if (this.keepAlive && "1.0".equals(this.version)) {
            this.buffer.put("Connection: keep-alive\r\n".getBytes());
        } else if (!this.keepAlive && "1.1".equals(this.version)) {
            this.buffer.put("Connection: close\r\n".getBytes());
        }
        this.buffer.put(CRLF);
        if (!this.onlyHeader && this.bufferedOutputStream != null && this.bufferedOutputStream.size() > 0) {
            int length;
            byte[] content = this.bufferedOutputStream.toByteArray();
            for (int index = 0; index < content.length; index += length) {
                length = Math.min(content.length - index, this.buffer.remaining());
                this.buffer.put(content, index, length);
                this.buffer.flip();
                this.channel.write(this.buffer);
                this.buffer.clear();
            }
        } else {
            this.buffer.flip();
            this.channel.write(this.buffer);
        }
        return this.keepAlive;
    }

    private String readLine() {
        StringBuilder b = new StringBuilder();
        while (this.buffer.hasRemaining()) {
            byte curr = this.buffer.get();
            if (curr == 13) {
                if (this.buffer.get() == 10) break;
                throw new MinijaxException("Unexpected CRLF pattern");
            }
            b.append((char)curr);
        }
        return b.toString();
    }

    private MultivaluedMap<String, String> readHeaders() {
        String line;
        MultivaluedHashMap headers = new MultivaluedHashMap();
        while ((line = this.readLine()) != null && line.length() > 0) {
            int colonIndex = line.indexOf(58);
            if (colonIndex < 0) continue;
            String key = line.substring(0, colonIndex).trim();
            String value = line.substring(colonIndex + 1).trim();
            headers.add((Object)key, (Object)value);
        }
        return headers;
    }

    private InputStream readContentBody() {
        String lenStr = (String)this.requestHeaders.getFirst((Object)"Content-Length");
        if (lenStr == null) {
            return null;
        }
        int len = Integer.parseInt(lenStr);
        if (len <= 0) {
            return null;
        }
        byte[] contentBody = new byte[len];
        this.buffer.get(contentBody);
        return new ByteArrayInputStream(contentBody);
    }

    private boolean shouldKeepAlive() {
        String str = (String)this.requestHeaders.getFirst((Object)"Connection");
        boolean keepAlive = str != null && str.contains("keep-alive");
        boolean close = str != null && str.contains("close");
        return this.version.equals("1.0") && keepAlive || this.version.equals("1.1") && !close;
    }
}

