/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.nio;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import org.minijax.Minijax;
import org.minijax.nio.BufferPool;
import org.minijax.nio.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Worker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Worker.class);
    private final Minijax minijax;
    private final Selector selector;
    private final BufferPool bufferPool;
    private final Queue<SocketChannel> incoming;
    private final List<Connection> connections;
    private volatile boolean running;
    private Worker nextWorker;

    public Worker(Minijax minijax, SelectorProvider selectorProvider) throws IOException {
        this.minijax = minijax;
        this.selector = selectorProvider.openSelector();
        this.bufferPool = new BufferPool();
        this.incoming = new ArrayBlockingQueue<SocketChannel>(1000);
        this.connections = new ArrayList<Connection>();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public Worker getNextWorker() {
        return this.nextWorker;
    }

    public void setNextWorker(Worker nextWorker) {
        if (this.nextWorker != null) {
            throw new IllegalStateException("nextWorker should only be set once");
        }
        this.nextWorker = nextWorker;
    }

    public void accept(SocketChannel socketChannel) {
        this.incoming.add(socketChannel);
        this.selector.wakeup();
    }

    @Override
    public void run() {
        LOG.debug("Starting worker...");
        this.running = true;
        try {
            while (this.running) {
                SocketChannel incomingChannel;
                while ((incomingChannel = this.incoming.poll()) != null) {
                    LOG.debug("Worker processing {}", (Object)incomingChannel);
                    incomingChannel.configureBlocking(false);
                    Socket socket = incomingChannel.socket();
                    socket.setSoTimeout(1000);
                    socket.setTcpNoDelay(true);
                    socket.setReceiveBufferSize(8192);
                    socket.setSendBufferSize(8192);
                    socket.setReuseAddress(true);
                    Connection conn = new Connection(this.minijax, incomingChannel, this.bufferPool.take());
                    this.connections.add(conn);
                    incomingChannel.register(this.selector, 1, conn);
                }
                if (this.selector.select(20L) <= 0) continue;
                Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> iter = selectedKeys.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    SocketChannel channel = (SocketChannel)key.channel();
                    Connection conn = (Connection)key.attachment();
                    boolean success = conn.handle();
                    if (success) continue;
                    channel.close();
                    this.bufferPool.give(conn.getBuffer());
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception in listener thread: {}", (Object)ex.getMessage(), (Object)ex);
        }
        LOG.debug("Worker done.");
    }
}

