/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import java.util.UUID;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.annotations.CacheIndex;
import org.minijax.db.DefaultBaseEntity;
import org.minijax.db.UuidConverter;
import org.minijax.security.SecurityUser;

@Entity
@Cacheable
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@Table(indexes={@Index(columnList="USERID", unique=false)})
@NamedQueries(value={@NamedQuery(name="ApiKey.findByUser", query="SELECT k FROM ApiKey k WHERE k.userId = :userId AND k.deletedDateTime IS NULL"), @NamedQuery(name="ApiKey.findByValue", query="SELECT k FROM ApiKey k WHERE k.value = :value")})
public class ApiKey
extends DefaultBaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(columnDefinition="BINARY(16)")
    @Convert(converter=UuidConverter.class)
    private UUID userId;
    private String name;
    @Column(length=64, unique=true)
    @CacheIndex
    private String value;

    public UUID getUserId() {
        return this.userId;
    }

    public void setUser(SecurityUser user) {
        this.userId = user.getId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void validate() {
        Validate.notNull((Object)this.userId, (String)"API key user must not be null.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)this.value, (String)"API key value must not be null or empty.", (Object[])new Object[0]);
    }
}

