/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import java.util.Arrays;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.Validate;
import org.mindrot.jbcrypt.BCrypt;
import org.minijax.db.DefaultNamedEntity;

@MappedSuperclass
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class SecurityUser
extends DefaultNamedEntity {
    private static final long serialVersionUID = 1L;
    @Column(length=128, unique=true)
    private String email;
    @XmlTransient
    private String roles;
    @XmlTransient
    private String passwordHash;

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPassword(String password) {
        this.passwordHash = BCrypt.hashpw((String)password, (String)BCrypt.gensalt());
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String ... roles) {
        Validate.notEmpty((Object[])roles, (String)"User roles cannot be empty.", (Object[])new Object[0]);
        this.roles = Arrays.asList(roles).toString();
    }

    public boolean hasRole(String role) {
        return this.roles != null && this.roles.contains(role);
    }

    public void validate() {
        super.validate();
        Validate.notEmpty((CharSequence)this.email, (String)"Email must not be null or empty.", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)128L, (long)this.email.length(), (String)"Email must be between 1 and 32 characters long");
        Validate.notEmpty((CharSequence)this.roles, (String)"Roles must not be null or empty.", (Object[])new Object[0]);
    }
}

