/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.Validate;
import org.minijax.db.BaseDao;
import org.minijax.security.ApiKey;
import org.minijax.security.PasswordChangeRequest;
import org.minijax.security.SecurityUser;
import org.minijax.security.UserSession;

public interface SecurityDao
extends BaseDao {
    default public List<ApiKey> findApiKeysByUser(SecurityUser user) {
        Validate.notNull((Object)((Object)user));
        return this.getEntityManager().createNamedQuery("ApiKey.findByUser", ApiKey.class).setParameter("userId", (Object)user.getId()).getResultList();
    }

    default public ApiKey findApiKeyByValue(String value) {
        return (ApiKey)((Object)this.getEntityManager().createNamedQuery("ApiKey.findByValue", ApiKey.class).setParameter("value", (Object)value).getSingleResult());
    }

    default public <T extends SecurityUser> T findUserByEmail(Class<T> entityClass, String email) {
        return (T)((Object)((SecurityUser)((Object)this.getEntityManager().createQuery("SELECT e FROM " + entityClass.getSimpleName() + " e WHERE e.email = :email", entityClass).setParameter("email", (Object)email).getSingleResult())));
    }

    default public PasswordChangeRequest findPasswordChangeRequest(String code) {
        return (PasswordChangeRequest)((Object)this.getEntityManager().createNamedQuery("PasswordChangeRequest.findByCode", PasswordChangeRequest.class).setParameter("code", (Object)code).getSingleResult());
    }

    default public void deleteUserSessionsByUser(UUID userId) {
        Validate.notNull((Object)userId);
        EntityManager em = this.getEntityManager();
        em.getTransaction().begin();
        em.createNamedQuery("UserSession.deleteByUser", UserSession.class).setParameter("userId", (Object)userId).executeUpdate();
        em.getTransaction().commit();
    }
}

