/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import java.util.UUID;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.minijax.db.DefaultBaseEntity;
import org.minijax.db.UuidConverter;
import org.minijax.security.SecurityUser;

@Entity
@Cacheable
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@Table(indexes={@Index(columnList="USERID", unique=false)})
@NamedQuery(name="PasswordChangeRequest.findByCode", query="SELECT pcr FROM PasswordChangeRequest pcr WHERE pcr.code = :code AND pcr.deletedDateTime IS NULL")
public class PasswordChangeRequest
extends DefaultBaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(columnDefinition="BINARY(16)")
    @Convert(converter=UuidConverter.class)
    @NotNull
    private UUID userId;
    @Column(length=64, unique=true)
    @Size(min=32, max=64)
    private @Size(min=32, max=64) String code;

    public UUID getUserId() {
        return this.userId;
    }

    public void setUser(SecurityUser user) {
        this.userId = user.getId();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

