/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import org.minijax.db.BaseDao;
import org.minijax.security.ApiKey;
import org.minijax.security.PasswordChangeRequest;
import org.minijax.security.SecurityUser;
import org.minijax.security.UserSession;

public interface SecurityDao
extends BaseDao {
    default public List<ApiKey> findApiKeysByUser(SecurityUser user) {
        return this.getEntityManager().createNamedQuery("ApiKey.findByUser", ApiKey.class).setParameter("userId", (Object)user.getId()).getResultList();
    }

    default public ApiKey findApiKeyByValue(String value) {
        return (ApiKey)BaseDao.firstOrNull((List)this.getEntityManager().createNamedQuery("ApiKey.findByValue", ApiKey.class).setParameter("value", (Object)value).getResultList());
    }

    default public <T extends SecurityUser> T findUserByEmail(Class<T> entityClass, String email) {
        return (T)((Object)((SecurityUser)BaseDao.firstOrNull((List)this.getEntityManager().createQuery("SELECT e FROM " + entityClass.getSimpleName() + " e WHERE e.email = :email", entityClass).setParameter("email", (Object)email).getResultList())));
    }

    default public PasswordChangeRequest findPasswordChangeRequest(String code) {
        return (PasswordChangeRequest)BaseDao.firstOrNull((List)this.getEntityManager().createNamedQuery("PasswordChangeRequest.findByCode", PasswordChangeRequest.class).setParameter("code", (Object)code).getResultList());
    }

    default public void deleteUserSessionsByUser(UUID userId) {
        EntityManager em = this.getEntityManager();
        em.getTransaction().begin();
        em.createNamedQuery("UserSession.deleteByUser", UserSession.class).setParameter("userId", (Object)userId).executeUpdate();
        em.getEntityManagerFactory().getCache().evict(UserSession.class);
        em.getTransaction().commit();
    }
}

