/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.UUID;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.CookieParam;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.mindrot.jbcrypt.BCrypt;
import org.minijax.db.BaseEntity;
import org.minijax.security.ApiKey;
import org.minijax.security.AuthUtils;
import org.minijax.security.ChangePasswordResult;
import org.minijax.security.LoginResult;
import org.minijax.security.PasswordChangeRequest;
import org.minijax.security.ResetPasswordResult;
import org.minijax.security.SecurityDao;
import org.minijax.security.SecurityUser;
import org.minijax.security.UserSession;
import org.minijax.util.IdUtils;

@Provider
@RequestScoped
public class Security<T extends SecurityUser>
implements SecurityContext {
    public static final int MINIMUM_PASSWORD_LENGTH = 8;
    public static final String COOKIE_NAME = "a";
    private static final String COOKIE_PATH = "/";
    private static final String COOKIE_DOMAIN = "";
    private static final int COOKIE_MAX_AGE = 31536000;
    private static final boolean COOKIE_HTTP_ONLY = true;
    private final Class<SecurityUser> userClass;
    private final SecurityDao dao;
    private final String authorization;
    private final String cookie;
    private final UserSession session;
    private final SecurityUser user;

    @Inject
    public Security(SecurityDao dao, @Context Configuration configuration, @HeaderParam(value="Authorization") String authorization, @CookieParam(value="a") String cookie) {
        this.userClass = (Class)configuration.getProperty("org.minijax.security.userClass");
        this.dao = dao;
        this.authorization = authorization;
        this.cookie = cookie;
        this.session = this.initUser();
        this.user = this.session != null ? this.session.getUser() : null;
    }

    public Class<SecurityUser> getUserClass() {
        return this.userClass;
    }

    public T getUserPrincipal() {
        return (T)((Object)this.user);
    }

    public boolean isLoggedIn() {
        return this.getUserPrincipal() != null;
    }

    public void requireLogin() {
        if (!this.isLoggedIn()) {
            throw new NotAuthorizedException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    private void requireCookieSession() {
        if (this.session.getId() == null) {
            throw new ForbiddenException();
        }
    }

    public String getSessionToken() {
        this.requireLogin();
        this.requireCookieSession();
        return this.session.getId().toString();
    }

    void validateSession(String token) {
        if (!Objects.equals(token, this.getSessionToken())) {
            throw new BadRequestException("Invalid session ID");
        }
    }

    public LoginResult login(String email, String password) {
        SecurityUser candidate = this.dao.findUserByEmail(this.userClass, email);
        if (candidate == null) {
            return LoginResult.NOT_FOUND;
        }
        if (candidate.getPasswordHash() == null) {
            return LoginResult.INVALID;
        }
        if (!BCrypt.checkpw((String)password, (String)candidate.getPasswordHash())) {
            return LoginResult.INCORRECT;
        }
        return new LoginResult(this.loginAs(candidate));
    }

    public NewCookie loginAs(SecurityUser candidate) {
        UserSession newSession = new UserSession();
        newSession.setUser(candidate);
        this.dao.create((BaseEntity)newSession);
        return this.createCookie(newSession.getId().toString(), 31536000);
    }

    public NewCookie logout() {
        if (this.session != null) {
            this.dao.purge((BaseEntity)this.session);
        }
        return this.createCookie(COOKIE_DOMAIN, 0);
    }

    public ChangePasswordResult changePassword(String oldPassword, String newPassword, String confirmNewPassword) {
        this.requireLogin();
        if (this.user.getPasswordHash() == null) {
            return ChangePasswordResult.INVALID;
        }
        if (!BCrypt.checkpw((String)oldPassword, (String)this.user.getPasswordHash())) {
            return ChangePasswordResult.INCORRECT;
        }
        if (!newPassword.equals(confirmNewPassword)) {
            return ChangePasswordResult.MISMATCH;
        }
        if (newPassword.length() < 8) {
            return ChangePasswordResult.TOO_SHORT;
        }
        this.user.setPassword(newPassword);
        this.dao.update((BaseEntity)this.user);
        return ChangePasswordResult.SUCCESS;
    }

    public String forgotPassword(SecurityUser user) {
        PasswordChangeRequest pcr = new PasswordChangeRequest();
        pcr.setCode(UUID.randomUUID().toString());
        pcr.setUser(user);
        this.dao.create((BaseEntity)pcr);
        return pcr.getCode();
    }

    public ResetPasswordResult resetPassword(String resetId, String newPassword, String confirmNewPassword) {
        PasswordChangeRequest pcr = this.dao.findPasswordChangeRequest(resetId);
        if (pcr == null) {
            return ResetPasswordResult.NOT_FOUND;
        }
        Instant expiration = pcr.getCreatedDateTime().plus(24L, ChronoUnit.HOURS);
        if (Instant.now().isAfter(expiration)) {
            return ResetPasswordResult.EXPIRED;
        }
        if (!newPassword.equals(confirmNewPassword)) {
            return ResetPasswordResult.MISMATCH;
        }
        if (newPassword.length() < 8) {
            return ResetPasswordResult.TOO_SHORT;
        }
        SecurityUser resetUser = (SecurityUser)this.dao.read(this.userClass, pcr.getUserId());
        if (resetUser == null) {
            return ResetPasswordResult.NOT_FOUND;
        }
        resetUser.setPassword(newPassword);
        this.dao.update((BaseEntity)resetUser);
        this.dao.purge((BaseEntity)pcr);
        return new ResetPasswordResult(this.loginAs(resetUser));
    }

    private UserSession initUser() {
        UserSession apiUser = this.tryGetApiUser();
        if (apiUser != null) {
            return apiUser;
        }
        UserSession rememberedUser = this.trySessionCookie();
        if (rememberedUser != null) {
            return rememberedUser;
        }
        return null;
    }

    private UserSession tryGetApiUser() {
        String authCode = AuthUtils.getUsername(this.authorization);
        if (authCode == null) {
            return null;
        }
        ApiKey apiKey = this.dao.findApiKeyByValue(authCode);
        if (apiKey == null || apiKey.getDeletedDateTime() != null) {
            return null;
        }
        SecurityUser apiUser = (SecurityUser)this.dao.read(this.userClass, apiKey.getUserId());
        if (apiUser == null) {
            return null;
        }
        UserSession apiSession = new UserSession();
        apiSession.setId(null);
        apiSession.setUser(apiUser);
        return apiSession;
    }

    private UserSession trySessionCookie() {
        if (this.cookie == null) {
            return null;
        }
        UUID sessionId = IdUtils.tryParse((String)this.cookie);
        if (sessionId == null) {
            return null;
        }
        UserSession rememberedSession = (UserSession)this.dao.read(UserSession.class, sessionId);
        if (rememberedSession == null) {
            return null;
        }
        SecurityUser sessionUser = (SecurityUser)this.dao.read(this.userClass, rememberedSession.getUserId());
        if (sessionUser == null) {
            return null;
        }
        rememberedSession.setUser(sessionUser);
        return rememberedSession;
    }

    private NewCookie createCookie(String value, int maxAge) {
        return new NewCookie(COOKIE_NAME, value, COOKIE_PATH, COOKIE_DOMAIN, COOKIE_DOMAIN, maxAge, false, true);
    }

    public boolean isUserInRole(String role) {
        return this.user != null && this.user.hasRole(role);
    }

    public boolean isSecure() {
        return true;
    }

    public String getAuthenticationScheme() {
        if (this.session == null) {
            return null;
        }
        if (this.session.getId() == null) {
            return "BASIC";
        }
        return "FORM";
    }
}

