/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import java.io.IOException;
import javax.enterprise.context.RequestScoped;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import org.minijax.MinijaxRequestContext;
import org.minijax.security.Security;

@RequestScoped
class CsrfFilter
implements ContainerRequestFilter {
    CsrfFilter() {
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!requestContext.getMethod().equals("POST")) {
            return;
        }
        MinijaxRequestContext ctx = (MinijaxRequestContext)requestContext;
        Security security = (Security)ctx.get(Security.class);
        if (!security.isLoggedIn()) {
            return;
        }
        String scheme = security.getAuthenticationScheme();
        if (scheme == null || !scheme.equals("FORM")) {
            return;
        }
        MediaType contentType = ctx.getMediaType();
        if (contentType == null) {
            return;
        }
        if (!contentType.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE) && !contentType.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE)) {
            return;
        }
        security.validateSession(ctx.getForm().getString("csrf"));
    }
}

