/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import java.util.Arrays;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.mindrot.jbcrypt.BCrypt;
import org.minijax.dao.DefaultNamedEntity;

@MappedSuperclass
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class SecurityUser
extends DefaultNamedEntity {
    private static final long serialVersionUID = 1L;
    @Column(length=128, unique=true)
    private String email;
    @XmlTransient
    @NotNull
    @Size(min=1, max=128)
    private @NotNull @Size(min=1, max=128) String roles;
    @XmlTransient
    private String passwordHash;

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPassword(String password) {
        this.passwordHash = BCrypt.hashpw((String)password, (String)BCrypt.gensalt());
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String ... roles) {
        this.roles = Arrays.asList(roles).toString();
    }

    public boolean hasRole(String role) {
        return this.roles != null && this.roles.contains(role);
    }
}

