/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class AuthUtils {
    private static final String BASIC_PREFIX = "Basic ";
    private static final String[] INVALID = new String[0];

    AuthUtils() {
        throw new UnsupportedOperationException();
    }

    public static String create(String username, String password) {
        return BASIC_PREFIX + Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    public static String getUsername(String auth) {
        String[] components = AuthUtils.getUsernamePassword(auth);
        return components == INVALID ? null : components[0];
    }

    public static String getPassword(String auth) {
        String[] components = AuthUtils.getUsernamePassword(auth);
        return components == INVALID ? null : components[1];
    }

    private static String[] getUsernamePassword(String auth) {
        byte[] decodedBytes;
        if (auth == null || !auth.startsWith(BASIC_PREFIX)) {
            return INVALID;
        }
        try {
            decodedBytes = Base64.getDecoder().decode(auth.substring(BASIC_PREFIX.length()));
        }
        catch (IllegalArgumentException ex) {
            return INVALID;
        }
        String decoded = new String(decodedBytes, StandardCharsets.UTF_8);
        int colonIndex = decoded.indexOf(58);
        if (colonIndex == -1) {
            return INVALID;
        }
        return decoded.split(":", 2);
    }
}

