/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Index;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.UUID;
import org.minijax.dao.DefaultBaseEntity;
import org.minijax.dao.converters.UuidConverter;
import org.minijax.security.SecurityUser;

@Entity
@Cacheable
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(indexes={@Index(columnList="USERID", unique=false)})
@NamedQueries(value={@NamedQuery(name="ApiKey.findByUser", query="SELECT k FROM ApiKey k WHERE k.userId = :userId AND k.deletedDateTime IS NULL"), @NamedQuery(name="ApiKey.findByValue", query="SELECT k FROM ApiKey k WHERE k.value = :value")})
public class ApiKey
extends DefaultBaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(columnDefinition="BINARY(16)")
    @Convert(converter=UuidConverter.class)
    @NotNull
    private UUID userId;
    private String name;
    @Column(length=64, unique=true)
    @Size(min=8, max=64)
    private @Size(min=8, max=64) String value;

    public UUID getUserId() {
        return this.userId;
    }

    public void setUser(SecurityUser user) {
        this.userId = user.getId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

