/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Index;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.UUID;
import org.minijax.dao.DefaultBaseEntity;
import org.minijax.dao.converters.UuidConverter;
import org.minijax.security.SecurityUser;

@Entity
@Cacheable
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(indexes={@Index(columnList="USERID")})
@NamedQuery(name="PasswordChangeRequest.findByCode", query="SELECT pcr FROM PasswordChangeRequest pcr WHERE pcr.code = :code AND pcr.deletedDateTime IS NULL")
public class PasswordChangeRequest
extends DefaultBaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(columnDefinition="BINARY(16)")
    @Convert(converter=UuidConverter.class)
    @NotNull
    private UUID userId;
    @Column(length=64, unique=true)
    @Size(min=32, max=64)
    private @Size(min=32, max=64) String code;

    public UUID getUserId() {
        return this.userId;
    }

    public void setUser(SecurityUser user) {
        this.userId = user.getId();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

