/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import jakarta.json.bind.annotation.JsonbTransient;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Arrays;
import org.mindrot.jbcrypt.BCrypt;
import org.minijax.dao.DefaultNamedEntity;

@MappedSuperclass
public abstract class SecurityUser
extends DefaultNamedEntity {
    private static final long serialVersionUID = 1L;
    @Column(length=128, unique=true)
    private String email;
    @JsonbTransient
    @NotNull
    @Size(min=1, max=128)
    private @NotNull @Size(min=1, max=128) String roles;
    @JsonbTransient
    private String passwordHash;

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPassword(String password) {
        this.passwordHash = BCrypt.hashpw((String)password, (String)BCrypt.gensalt());
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String ... roles) {
        this.roles = Arrays.asList(roles).toString();
    }

    public boolean hasRole(String role) {
        return this.roles != null && this.roles.contains(role);
    }
}

