/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.security;

import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Index;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.util.UUID;
import org.minijax.dao.DefaultBaseEntity;
import org.minijax.dao.converters.UuidConverter;
import org.minijax.security.SecurityUser;

@Entity
@Cacheable
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(indexes={@Index(columnList="USERID")})
@NamedQueries(value={@NamedQuery(name="UserSession.readByUser", query="SELECT s FROM UserSession s WHERE s.userId = :userId"), @NamedQuery(name="UserSession.deleteByUser", query="DELETE FROM UserSession s WHERE s.userId = :userId")})
public class UserSession
extends DefaultBaseEntity {
    private static final long serialVersionUID = 1L;
    @Column(columnDefinition="BINARY(16)")
    @Convert(converter=UuidConverter.class)
    @NotNull
    private UUID userId;
    @Transient
    private SecurityUser user;

    public UUID getUserId() {
        return this.userId;
    }

    public SecurityUser getUser() {
        return this.user;
    }

    public void setUser(SecurityUser user) {
        this.userId = user.getId();
        this.user = user;
    }
}

