/*
 * Decompiled with CFR 0.152.
 */
package org.minijax.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class View {
    private final String templateName;
    private final Map<String, Object> model;

    public View(String templateName) {
        this.templateName = templateName;
        this.model = new HashMap<String, Object>();
    }

    public View(String templateName, String title) {
        this(templateName);
        this.model.put("title", title);
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public Map<String, Object> getModel() {
        return this.model;
    }

    public List<Alert> getAlerts() {
        return (List)this.model.computeIfAbsent("alerts", k -> new ArrayList());
    }

    public void addAlert(Alert alert) {
        this.getAlerts().add(alert);
    }

    public void addSuccessAlert(String msg) {
        this.addAlert(new Alert(AlertType.SUCCESS, msg));
    }

    public void addInfoAlert(String msg) {
        this.addAlert(new Alert(AlertType.INFO, msg));
    }

    public void addWarningAlert(String msg) {
        this.addAlert(new Alert(AlertType.WARNING, msg));
    }

    public void addDangerAlert(String msg) {
        this.addAlert(new Alert(AlertType.DANGER, msg));
    }

    public static class Alert {
        private final AlertType alertType;
        private final String message;

        public Alert(AlertType alertType, String message) {
            this.alertType = alertType;
            this.message = message;
        }

        public AlertType getAlertType() {
            return this.alertType;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStyle() {
            return "alert alert-" + this.alertType.toString().toLowerCase();
        }
    }

    public static enum AlertType {
        SUCCESS,
        INFO,
        WARNING,
        DANGER;

    }
}

