# This is a custom classloader impl to allow loading classes with
# interdependencies by having findClass retrieve classes as needed from the
# collection of all classes generated by the target script.
module Mirah
  class ClassLoader < java::security::SecureClassLoader
    def initialize(parent, class_map)
      super(parent)
      @class_map = class_map
    end
    
    def findClass(name)
      if @class_map[name]
        bytes = @class_map[name].to_java_bytes
        defineClass(name, bytes, 0, bytes.length)
      else
        raise java.lang.ClassNotFoundException.new(name)
      end
    end
    
    def loadClass(name, resolve)
      cls = findLoadedClass(name)
      if cls == nil
        if @class_map[name]
          cls = findClass(name)
        else
          cls = super(name, false)
        end
      end
      
      resolveClass(cls) if resolve
      
      cls
    end
  end
end