package org.mirah;

import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.RubyClass;
import java.util.List;
import java.lang.System;


public class MirahCommand extends RubyObject  {
    private static final Ruby __ruby__ = Ruby.getGlobalRuntime();
    private static final RubyClass __metaclass__;

    static {
        String source = new StringBuilder("# Copyright (c) 2010 The Mirah project authors. All Rights Reserved.\n" +
            "# All contributing project authors may be found in the NOTICE file.\n" +
            "#\n" +
            "# Licensed under the Apache License, Version 2.0 (the \"License\");\n" +
            "# you may not use this file except in compliance with the License.\n" +
            "# You may obtain a copy of the License at\n" +
            "#\n" +
            "#      http://www.apache.org/licenses/LICENSE-2.0\n" +
            "#\n" +
            "# Unless required by applicable law or agreed to in writing, software\n" +
            "# distributed under the License is distributed on an \"AS IS\" BASIS,\n" +
            "# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n" +
            "# See the License for the specific language governing permissions and\n" +
            "# limitations under the License.\n" +
            "\n" +
            "require 'java'\n" +
            "require 'mirah'\n" +
            "\n" +
            "java_import 'java.util.List'\n" +
            "java_import 'java.lang.System'\n" +
            "\n" +
            "java_package \"org.mirah\"\n" +
            "class MirahCommand\n" +
            "  java_signature \"void main(String[])\"\n" +
            "  def self.main(args)\n" +
            "    rb_args = args.to_a\n" +
            "    command = rb_args.shift.to_s\n" +
            "    \n" +
            "    # force $0 to something explanatory\n" +
            "    $0 = \"<mirah #{command}>\"\n" +
            "    \n" +
            "    # for OS X, set property for Dock title\n" +
            "    System.setProperty(\"com.apple.mrj.application.apple.menu.about.name\", \"Mirah Runner\")\n" +
            "    \n" +
            "    case command\n" +
            "    when \"compile\"\n" +
            "      MirahCommand.compile(rb_args)\n" +
            "    when \"run\"\n" +
            "      MirahCommand.run(rb_args)\n" +
            "    else\n" +
            "      $stderr.puts \"Usage: compile <script> or run <script>\"\n" +
            "    end\n" +
            "  end\n" +
            "\n" +
            "  java_signature 'void compile(List args)'\n" +
            "  def self.compile(args)\n" +
            "    Mirah.compile(*args)\n" +
            "  end\n" +
            "\n" +
            "  java_signature 'void run(List args)'\n" +
            "  def self.run(args)\n" +
            "    Mirah.run(*args)\n" +
            "  end\n" +
            "end").toString();
        __ruby__.executeScript(source, "src/org/mirah/mirah_command.rb");
        RubyClass metaclass = __ruby__.getClass("MirahCommand");
        metaclass.setRubyStaticAllocator(MirahCommand.class);
        if (metaclass == null) throw new NoClassDefFoundError("Could not load Ruby class: MirahCommand");
        __metaclass__ = metaclass;
    }

    /**
     * Standard Ruby object constructor, for construction-from-Ruby purposes.
     * Generally not for user consumption.
     *
     * @param ruby The JRuby instance this object will belong to
     * @param metaclass The RubyClass representing the Ruby class of this object
     */
    private MirahCommand(Ruby ruby, RubyClass metaclass) {
        super(ruby, metaclass);
    }

    /**
     * A static method used by JRuby for allocating instances of this object
     * from Ruby. Generally not for user comsumption.
     *
     * @param ruby The JRuby instance this object will belong to
     * @param metaclass The RubyClass representing the Ruby class of this object
     */
    public static IRubyObject __allocate__(Ruby ruby, RubyClass metaClass) {
        return new MirahCommand(ruby, metaClass);
    }
        
    /**
     * Default constructor. Invokes this(Ruby, RubyClass) with the classloader-static
     * Ruby and RubyClass instances assocated with this class, and then invokes the
     * no-argument 'initialize' method in Ruby.
     *
     * @param ruby The JRuby instance this object will belong to
     * @param metaclass The RubyClass representing the Ruby class of this object
     */
    public MirahCommand() {
        this(__ruby__, __metaclass__);
        RuntimeHelpers.invoke(__ruby__.getCurrentContext(), this, "initialize");
    }

    
    public static void main(String[] args) {
        IRubyObject ruby_args = JavaUtil.convertJavaToRuby(__ruby__, args);
        IRubyObject ruby_result = RuntimeHelpers.invoke(__ruby__.getCurrentContext(), __metaclass__, "main", ruby_args);
        return;

    }

    
    public static void compile(List args) {
        IRubyObject ruby_args = JavaUtil.convertJavaToRuby(__ruby__, args);
        IRubyObject ruby_result = RuntimeHelpers.invoke(__ruby__.getCurrentContext(), __metaclass__, "compile", ruby_args);
        return;

    }

    
    public static void run(List args) {
        IRubyObject ruby_args = JavaUtil.convertJavaToRuby(__ruby__, args);
        IRubyObject ruby_result = RuntimeHelpers.invoke(__ruby__.getCurrentContext(), __metaclass__, "run", ruby_args);
        return;

    }

}
