/*
 * Decompiled with CFR 0.152.
 */
package mirah.lang.ast;

import java.util.List;
import mirah.lang.ast.AnnotationList;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeVisitor;
import mirah.lang.ast.Position;
import mirah.lang.ast.TypeName;
import mirah.lang.ast.TypeNameList;

public class ClosureDefinition
extends ClassDefinition {
    private NodeList body;
    private TypeName superclass;
    private Identifier name;
    private TypeNameList interfaces;
    private AnnotationList annotations;

    public ClosureDefinition() {
    }

    public ClosureDefinition(Position position) {
        this.position_set(position);
    }

    public ClosureDefinition(Position position, Identifier name, TypeName superclass, List body, List interfaces, List annotations) {
        this.position_set(position);
        this.name_set(name);
        this.superclass_set(superclass);
        this.body_set(new NodeList(position, body));
        this.interfaces_set(new TypeNameList(position, interfaces));
        this.annotations_set(new AnnotationList(position, annotations));
    }

    public ClosureDefinition(Identifier name, TypeName superclass, List body, List interfaces, List annotations) {
        this.name_set(name);
        this.superclass_set(superclass);
        this.body_set(new NodeList(this.position(), body));
        this.interfaces_set(new TypeNameList(this.position(), interfaces));
        this.annotations_set(new AnnotationList(this.position(), annotations));
    }

    @Override
    public Node replaceChild(Node oldChild, Node newChild) {
        if (oldChild == newChild) {
            return newChild;
        }
        Node clone = this.childAdded(newChild);
        if (this.name() == oldChild) {
            this.name_set((Identifier)clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        if (this.superclass() == oldChild) {
            this.superclass_set((TypeName)clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        throw new IllegalArgumentException("No child " + oldChild);
    }

    @Override
    public void removeChild(Node child) {
        if (this.name() == child) {
            this.name_set(null);
            return;
        }
        if (this.superclass() == child) {
            this.superclass_set(null);
            return;
        }
        throw new IllegalArgumentException("No child " + child);
    }

    @Override
    public void initCopy() {
        block4: {
            super.initCopy();
            if (this.name() != null) {
                this.name = (Identifier)this.childAdded((Node)this.name().clone());
            }
            if (this.superclass() != null) {
                this.superclass = (TypeName)this.childAdded((Node)this.superclass().clone());
            }
            if (this.body() != null) {
                this.body = (NodeList)this.childAdded((Node)this.body().clone());
            }
            if (this.interfaces() != null) {
                this.interfaces = (TypeNameList)this.childAdded((Node)this.interfaces().clone());
            }
            if (this.annotations() == null) break block4;
            this.annotations = (AnnotationList)this.childAdded((Node)this.annotations().clone());
        }
    }

    @Override
    public Object accept(NodeVisitor visitor, Object arg) {
        return visitor.visitClosureDefinition(this, arg);
    }
}

