/*
 * Decompiled with CFR 0.152.
 */
package mirah.lang.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeImpl;
import mirah.lang.ast.NodeVisitor;
import mirah.lang.ast.Position;
import mirah.lang.ast.RescueClause;
import mirah.lang.ast.RescueClauseListIterator;

public class RescueClauseList
extends NodeImpl
implements Iterable {
    private ArrayList children;

    public void common_init(int size) {
        this.children = size < 0 ? new ArrayList() : new ArrayList(size);
    }

    public RescueClauseList() {
        this.common_init(-1);
    }

    public RescueClauseList(Position position) {
        this.position_set(position);
        this.common_init(-1);
    }

    public RescueClauseList(List children) {
        if (children != null) {
            this.common_init(children.size());
            Position startPosition = null;
            Position endPosition = null;
            for (Node _node : children) {
                Node node = _node;
                if (node == null) continue;
                this.children.add(this.childAdded(node));
                if (startPosition == null) {
                    startPosition = node.position();
                }
                endPosition = node.position();
            }
            if (!this.children.isEmpty()) {
                this.position_set(startPosition.add(endPosition));
            }
        } else {
            this.common_init(-1);
        }
    }

    public RescueClauseList(Position position, List children) {
        this.position_set(position);
        if (children != null) {
            this.common_init(children.size());
            for (Node node : children) {
                this.children.add(this.childAdded(node));
            }
        } else {
            this.common_init(-1);
        }
    }

    public int size() {
        return this.children.size();
    }

    public RescueClause get(int i) {
        Object child = this.children.get(i);
        return (RescueClause)child;
    }

    public RescueClause set(int i, RescueClause node) {
        block0: {
            RescueClause current = this.get(i);
            if (current == node) break block0;
            this.childRemoved(current);
            this.children.set(i, this.childAdded(node));
        }
        return node;
    }

    @Override
    public Node replaceChild(Node oldChild, Node newChild) {
        if (oldChild == newChild) {
            return newChild;
        }
        int i = this.children.indexOf(oldChild);
        Node clone = this.childAdded(newChild);
        this.set(i, (RescueClause)clone);
        clone.setOriginalNode(oldChild);
        return clone;
    }

    @Override
    public void removeChild(Node child) {
        this.children.remove(child);
    }

    @Override
    public void initCopy() {
        super.initCopy();
        ArrayList<Node> new_children = new ArrayList<Node>(this.children.size());
        for (Object child : this.children) {
            new_children.add(child != null ? this.childAdded((Node)((Node)child).clone()) : null);
        }
        this.children = new_children;
    }

    public void add(RescueClause node) {
        this.children.add(this.childAdded(node));
    }

    public void insert(int i, RescueClause node) {
        this.children.add(i, this.childAdded(node));
    }

    public RescueClause remove(int i) {
        Node node = (Node)this.children.remove(i);
        this.childRemoved(node);
        return (RescueClause)node;
    }

    @Override
    public Object accept(NodeVisitor visitor, Object arg) {
        return visitor.visitRescueClauseList(this, arg);
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int start) {
        return new RescueClauseListIterator(this, start);
    }
}

