/*
 * Decompiled with CFR 0.152.
 */
package mirah.lang.ast;

import mirah.lang.ast.CodeSource;

public class StringCodeSource
implements CodeSource {
    private int startCol;
    private int startLine;
    private String name;
    private String code;

    public StringCodeSource(String name, String code) {
        this.name = name;
        this.code = code;
        this.startLine = 1;
        this.startCol = 1;
    }

    public StringCodeSource(String name, String code, int startLine, int startCol) {
        this.name = name;
        this.code = code;
        this.startLine = startLine;
        this.startCol = startCol;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String contents() {
        return this.code;
    }

    @Override
    public String substring(int startPos, int endPos) {
        return this.code.substring(startPos, endPos);
    }

    @Override
    public int initialLine() {
        return this.startLine;
    }

    @Override
    public int initialColumn() {
        return this.startCol;
    }

    public String toString() {
        return this.name + " " + this.code + " " + this.startLine + ":" + this.startCol;
    }
}

