/*
 * Decompiled with CFR 0.152.
 */
package org.mirah;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MirahLogFormatter
extends Formatter {
    private Map names;
    private boolean color;
    private Map inverse_names;

    public MirahLogFormatter(boolean use_color) {
        this.color = use_color;
        this.names = new HashMap(16);
        this.inverse_names = new HashMap(16);
    }

    public void format_name(StringBuilder sb, int level, String name) {
        block5: {
            if (this.color) {
                sb.append("\u001b[1m");
            }
            sb.append("* [");
            boolean bl = this.color ? level > 800 : false;
            if (bl) {
                if (level > 900) {
                    sb.append("\u001b[31m");
                } else {
                    sb.append("\u001b[34m");
                }
            }
            sb.append(this.shorten(name));
            if (this.color) {
                sb.append("\u001b[39m");
            }
            sb.append("] ");
            if (!this.color) break block5;
            sb.append("\u001b[0m");
        }
    }

    public String shorten(String name) {
        String string = (String)this.names.get(name);
        if (string != null) {
            return string;
        }
        int i = 0;
        List<String> pieces = Arrays.asList(name.split("\\."));
        int gensym0 = pieces.size();
        if (i < gensym0) {
            do {
                boolean bl;
                List<String> key;
                List existing;
                boolean $or$1;
                boolean bl2 = $or$1 = (existing = (List)this.inverse_names.get(key = pieces.subList(pieces.size() - i - 1, pieces.size()))) == null;
                if ($or$1) {
                    bl = $or$1;
                } else {
                    ArrayList<String> arrayList = new ArrayList<String>(1);
                    arrayList.add(name);
                    bl = existing == arrayList;
                }
                if (bl) {
                    ArrayList<String> arrayList = new ArrayList<String>(1);
                    arrayList.add(name);
                    this.inverse_names.put(key, arrayList);
                    String val1 = this.join(key, ".");
                    this.names.put(name, val1);
                    return val1;
                }
                for (Object e : existing) {
                    this.names.put(e, null);
                }
                if (existing.contains(name)) continue;
                existing.add(name);
            } while (++i < gensym0);
        }
        return name;
    }

    public String join(Iterable list, String sep) {
        StringBuilder sb = new StringBuilder();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb;
        block0: {
            sb = new StringBuilder();
            this.format_name(sb, record.getLevel().intValue(), record.getLoggerName());
            sb.append(this.formatMessage(record));
            sb.append("\n");
            if (record.getThrown() == null) break block0;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            sb.append(sw.toString());
        }
        return sb.toString();
    }

    public Logger install() {
        Logger logger = Logger.getLogger("org.mirah");
        boolean gensym0 = false;
        int gensym2 = 0;
        Handler[] gensym1 = logger.getHandlers();
        if (gensym2 < gensym1.length) {
            do {
                Handler h;
                if (!((h = gensym1[gensym2]).getFormatter() instanceof MirahLogFormatter)) continue;
                gensym0 = true;
                break;
            } while (++gensym2 < gensym1.length);
        }
        if (gensym0) {
            return logger;
        }
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        handler.setFormatter(this);
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        return logger;
    }
}

