/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import javax.tools.DiagnosticListener;
import mirah.lang.ast.Script;
import org.mirah.jvm.compiler.AnnotationCompiler;
import org.mirah.jvm.compiler.BytecodeConsumer;
import org.mirah.jvm.compiler.JvmVersion;
import org.mirah.jvm.compiler.ProxyCleanup;
import org.mirah.jvm.compiler.ScriptCleanup;
import org.mirah.jvm.compiler.ScriptCompiler;
import org.mirah.macros.Compiler;
import org.mirah.typer.Typer;
import org.mirah.util.Context;
import org.mirah.util.SimpleDiagnostics;

public class Backend {
    private SimpleDiagnostics diagnostics;
    private Context context;
    private ScriptCompiler compiler;

    public Backend(Context context) {
        this.context = context;
        this.diagnostics = (SimpleDiagnostics)context.get(SimpleDiagnostics.class);
        this.context.add(Compiler.class, ((Typer)this.context.get(Typer.class)).macro_compiler());
        this.context.add(AnnotationCompiler.class, new AnnotationCompiler(this.context));
        this.compiler = new ScriptCompiler(this.context);
        if ((JvmVersion)this.context.get(JvmVersion.class) == null) {
            this.context.add(JvmVersion.class, new JvmVersion());
        }
    }

    public Backend(Typer typer) {
        this.context = new Context();
        this.context.add(Typer.class, typer);
        this.diagnostics = new SimpleDiagnostics(true);
        this.context.add(DiagnosticListener.class, this.diagnostics);
        this.context.add(Compiler.class, typer.macro_compiler());
        this.context.add(AnnotationCompiler.class, new AnnotationCompiler(this.context));
        this.compiler = new ScriptCompiler(this.context);
    }

    public void visit(Script script, Object arg) {
        this.clean(script, arg);
        this.compile(script, arg);
    }

    public void clean(Script script, Object arg) {
        script.accept(new ProxyCleanup(), arg);
        script.accept(new ScriptCleanup(this.context), arg);
    }

    public void compile(Script script, Object arg) {
        script.accept(this.compiler, arg);
    }

    public Object generate(BytecodeConsumer consumer) {
        if (this.diagnostics.errorCount() > 0) {
            throw new UnsupportedOperationException("Compilation failed");
        }
        return this.compiler.generate(consumer);
    }
}

