/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import mirah.lang.ast.Call;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.Ensure;
import mirah.lang.ast.FunctionalCall;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.Rescue;
import mirah.lang.ast.Self;
import mirah.lang.ast.SimpleNodeVisitor;
import mirah.lang.ast.Super;
import mirah.lang.ast.ZSuper;
import org.mirah.typer.Typer;
import org.mirah.util.AstFormatter;
import org.mirah.util.Context;

public class ConstructorCleanup
extends SimpleNodeVisitor {
    private Typer typer;
    private static Logger log = Logger.getLogger(ConstructorCleanup.class.getName());
    private Context context;

    public ConstructorCleanup(Context context) {
        this.context = context;
        this.typer = (Typer)context.get(Typer.class);
    }

    public void clean(ConstructorDefinition constructor, NodeList extra_init) {
        log.log(Level.FINER, "Before cleanup {0}", new AstFormatter(constructor));
        Object found_delegate = constructor.body().accept(this, extra_init);
        log.finest("found_delegate: " + found_delegate);
        if (!Boolean.TRUE.equals(found_delegate)) {
            Super delegate = new Super(constructor.name().position(), Collections.emptyList(), null);
            constructor.body().insert(0, delegate);
            this.typer.infer(delegate, false);
            this.insertNodesAfter(constructor.body().get(0), extra_init);
        }
        log.log(Level.FINE, "After cleanup {0}", new AstFormatter(constructor));
    }

    @Override
    public Object defaultNode(Node node, Object arg) {
        return null;
    }

    @Override
    public Object visitNodeList(NodeList node, Object arg) {
        int i = 0;
        int gensym0 = node.size();
        if (i < gensym0) {
            do {
                Node child;
                if ((child = node.get(i)) instanceof ClassDefinition) continue;
                return child.accept(this, arg);
            } while (++i < gensym0);
        }
        return null;
    }

    @Override
    public Object visitEnsure(Ensure node, Object arg) {
        return node.body() != null ? node.body().accept(this, arg) : null;
    }

    @Override
    public Object visitRescue(Rescue node, Object arg) {
        return node.body() != null ? node.body().accept(this, arg) : null;
    }

    @Override
    public Object visitZSuper(ZSuper node, Object arg) {
        this.insertNodesAfter(node, arg);
        return Boolean.TRUE;
    }

    @Override
    public Object visitSuper(Super node, Object arg) {
        this.insertNodesAfter(node, arg);
        return Boolean.TRUE;
    }

    @Override
    public Object visitFunctionalCall(FunctionalCall node, Object arg) {
        return "initialize".equals(node.name().identifier()) ? Boolean.TRUE : null;
    }

    @Override
    public Object visitCall(Call node, Object arg) {
        return (node.target() instanceof Self ? "initialize".equals(node.name().identifier()) : false) ? Boolean.TRUE : null;
    }

    public void insertNodesAfter(Node node, Object arg) {
        block0: {
            if (arg == null) break block0;
            NodeList parent = (NodeList)node.parent();
            parent.insert(1, (Node)arg);
            this.typer.infer(parent.get(1));
        }
    }
}

