/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.Block;
import mirah.lang.ast.Call;
import mirah.lang.ast.CallSite;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.Constant;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.ImplicitNil;
import mirah.lang.ast.LocalAccess;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.Position;
import mirah.lang.ast.Raise;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.Rescue;
import mirah.lang.ast.RescueClause;
import mirah.lang.ast.Return;
import mirah.lang.ast.Script;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.StaticMethodDefinition;
import org.mirah.jvm.compiler.ClosureTransformer;
import org.mirah.jvm.compiler.NLRStruct;
import org.mirah.jvm.compiler.Utils;
import org.mirah.macros.MacroBuilder;
import org.mirah.typer.BlockFuture;
import org.mirah.typer.MethodFuture;
import org.mirah.typer.MethodType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.Typer;
import org.mirah.typer.simple.TypePrinter;
import org.mirah.util.Context;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NLRTransformer
extends NodeScanner {
    private Typer typer;
    private MacroBuilder parser;
    private ClassDefinition nlr_exception_class;
    private static Logger log = Logger.getLogger(ClosureTransformer.class.getName());
    private Context context;
    private Scoper scoper;
    private boolean in_block;

    public NLRTransformer(Context context) {
        this.context = context;
        this.typer = (Typer)context.get(Typer.class);
        this.scoper = this.typer.scoper();
        this.parser = this.typer.macro_compiler();
    }

    @Override
    public boolean enterScript(Script node, Object arg) {
        this.maybe_build_nlr_exception(node, (NLRStruct)arg);
        return true;
    }

    @Override
    public boolean enterMethodDefinition(MethodDefinition node, Object arg) {
        this.maybe_build_nlr_exception(node, (NLRStruct)arg);
        return true;
    }

    @Override
    public boolean enterStaticMethodDefinition(StaticMethodDefinition node, Object arg) {
        this.maybe_build_nlr_exception(node, (NLRStruct)arg);
        return true;
    }

    public void maybe_build_nlr_exception(Node node, NLRStruct arg) {
        block0: {
            if (arg.root() != node) break block0;
            this.nlr_exception_class = this.build_nlr_exception(node);
            arg.toInject().add(this.nlr_exception_class);
        }
    }

    @Override
    public Object exitScript(Script node, Object arg) {
        this.exit_method(node, arg);
        return node;
    }

    @Override
    public Object exitMethodDefinition(MethodDefinition node, Object arg) {
        this.exit_method(node, arg);
        return node;
    }

    @Override
    public Object exitStaticMethodDefinition(StaticMethodDefinition node, Object arg) {
        this.exit_method(node, arg);
        return node;
    }

    @Override
    public boolean enterBlock(Block node, Object arg) {
        this.in_block = true;
        return true;
    }

    @Override
    public boolean enterReturn(Return node, Object arg) {
        if (!this.in_block) {
            return false;
        }
        this.replace_return_with_nlr_raise(node);
        return true;
    }

    @Override
    public Object exitBlock(Block node, Object arg) {
        this.in_block = false;
        this.build_and_inject_closure(node, (NLRStruct)arg);
        return node;
    }

    public void exit_method(Node node, Object arg) {
        if (((NLRStruct)arg).root() != node) {
            return;
        }
        NodeList body = Utils.enclosing_body(node);
        Identifier nlr_exception_name = this.nlr_exception_class.name();
        ResolvedType return_value_type = node instanceof MethodDefinition ? ((MethodType)this.typer.infer(node).resolve()).returnType() : (node instanceof Script ? this.typer.infer(node).resolve() : null);
        log.finest("return value of " + node + ": " + return_value_type + " is void? " + this.void_type?(return_value_type));
        Node return_value = this.void_type?(return_value_type) ? (Node)new ImplicitNil() : (Node)new Call(node.position(), new LocalAccess(new SimpleString("return_exception")), new SimpleString("return_value"), Collections.emptyList(), null);
        Position position = node.position();
        ArrayList arrayList = new ArrayList(0);
        ArrayList<RescueClause> arrayList2 = new ArrayList<RescueClause>(1);
        Position position2 = node.position();
        ArrayList<Identifier> arrayList3 = new ArrayList<Identifier>(1);
        arrayList3.add(nlr_exception_name);
        SimpleString simpleString = new SimpleString("return_exception");
        ArrayList<Return> arrayList4 = new ArrayList<Return>(1);
        arrayList4.add(new Return(node.position(), return_value));
        arrayList2.add(new RescueClause(position2, arrayList3, simpleString, arrayList4));
        Rescue new_body = new Rescue(position, arrayList, arrayList2, null);
        new_body.body_set(body);
        Position position3 = node.position();
        ArrayList<Rescue> arrayList5 = new ArrayList<Rescue>(1);
        arrayList5.add(new_body);
        NodeList real_new_body = new NodeList(position3, arrayList5);
        if (node instanceof Script) {
            ((Script)node).body_set(real_new_body);
        } else {
            ((MethodDefinition)node).body_set(real_new_body);
        }
        this.typer.infer(real_new_body);
        Utils.inject_nodes(real_new_body, ((NLRStruct)arg).toInject(), this.typer);
    }

    public TypeFuture infer(Node node) {
        return this.typer.infer(node);
    }

    public Block build_and_inject_closure(Block node, NLRStruct struct) {
        Arguments args;
        Node ancestor = Utils.find_enclosing_method_node(node);
        NodeList enclosing_body = Utils.enclosing_body(ancestor);
        Scope method_scope = this.scoper.getScope(enclosing_body);
        Scope $ptemp$1 = method_scope;
        ResolvedType $or$2 = $ptemp$1.binding_type();
        if ($or$2 == null) {
            ClosureDefinition binding_klass = this.build_binding(node);
            Utils.insert_in_front(enclosing_body, binding_klass);
            $ptemp$1.binding_type_set(this.infer(binding_klass).resolve());
        }
        BlockFuture future = (BlockFuture)this.typer.getInferredType(node);
        ClosureDefinition closure_definition = Utils.build_class(node.position(), future.resolve(), this.build_temp_name("Closure", enclosing_body));
        closure_definition.body().add(Utils.build_closure_constructor(node.position(), method_scope.binding_type()));
        MethodType mtype = future.basic_block_method_type();
        Arguments arguments = args = node.arguments() != null ? (Arguments)node.arguments().clone() : new Arguments(node.position(), Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), null);
        while (args.required().size() < mtype.parameterTypes().size()) {
            RequiredArgument arg = new RequiredArgument(node.position(), new SimpleString("arg" + args.required().size()), null);
            args.required().add(arg);
        }
        Constant return_type = Utils.makeTypeName(node.position(), mtype.returnType());
        MethodDefinition method = new MethodDefinition(node.position(), new SimpleString(mtype.name()), args, return_type, null, null);
        method.body_set((NodeList)node.body().clone());
        this.set_parent_scope(method, this.scoper.getScope(node));
        closure_definition.body().add(method);
        struct.toInject().add(closure_definition);
        Call new_closure = Utils.closure_call_node(node.position(), closure_definition);
        this.infer(new_closure);
        Utils.replace_block_with_closure_in_call((CallSite)node.parent(), node, new_closure);
        return node;
    }

    public void replace_return_with_nlr_raise(Return node) {
        Raise raise;
        Identifier nlr_exception_name = this.nlr_exception_class.name();
        if (node.value() instanceof ImplicitNil) {
            ArrayList<Identifier> arrayList = new ArrayList<Identifier>(1);
            arrayList.add(nlr_exception_name);
            raise = (Raise)this.parser.deserializeAst("src/org/mirah/jvm/compiler/closure_transformer.mirah", 366, 44, "raise `nlr_exception_name`.new", arrayList);
        } else {
            ArrayList<Node> arrayList = new ArrayList<Node>(2);
            arrayList.add(nlr_exception_name);
            arrayList.add(node.value());
            raise = (Raise)this.parser.deserializeAst("src/org/mirah/jvm/compiler/closure_transformer.mirah", 368, 44, "raise `nlr_exception_name`.new `node.value`", arrayList);
        }
        Raise raise_expression = raise;
        log.finest("replacing return with raise " + nlr_exception_name);
        node.parent().replaceChild(node, raise_expression);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(buf);
        TypePrinter printer = new TypePrinter(this.typer, ps);
        printer.scan(raise_expression, null);
        ps.close();
        log.finest("before intypes for raise expr:\n" + new String(buf.toByteArray()));
        this.infer(raise_expression);
        buf = new ByteArrayOutputStream();
        ps = new PrintStream(buf);
        printer = new TypePrinter(this.typer, ps);
        printer.scan(raise_expression, null);
        ps.close();
        log.finest("Inferred types for raise expr:\n" + new String(buf.toByteArray()));
    }

    public String build_temp_name(String middle_fix, Node block) {
        return this.scoper.getScope(block).temp(Utils.build_name_prefix(block) + "$" + middle_fix);
    }

    public Scope set_parent_scope(MethodDefinition method, Scope parent_scope) {
        Scope scope = this.scoper.addScope(method);
        scope.parent_set(parent_scope);
        return scope;
    }

    public ClosureDefinition build_binding(Block node) {
        Node md = node.findAncestor(MethodDefinition.class);
        MethodFuture mt = (MethodFuture)this.typer.infer(md);
        String klass_name = this.build_temp_name("Binding", node);
        ClosureDefinition klass = Utils.build_class(node.position(), null, klass_name);
        return klass;
    }

    public boolean void_type?(ResolvedType type) {
        return this.void_type().equals(type);
    }

    public ResolvedType void_type() {
        return this.typer.type_system().getVoidType().resolve();
    }

    public ClassDefinition build_nlr_exception(Node node) {
        List list;
        List list2;
        ClosureDefinition klass = Utils.build_class(node.position(), this.typer.type_system().getBaseExceptionType().resolve(), this.build_temp_name("NonLocalReturn", node));
        ResolvedType return_value_type = node instanceof MethodDefinition ? ((MethodType)this.typer.infer(node).resolve()).returnType() : (node instanceof Script ? this.void_type() : null);
        klass.body().add((MethodDefinition)this.parser.deserializeAst("src/org/mirah/jvm/compiler/closure_transformer.mirah", 427, 38, "def fillInStackTrace; end", new ArrayList(0)));
        if (!this.void_type?(return_value_type)) {
            klass.body().add((MethodDefinition)this.parser.deserializeAst("src/org/mirah/jvm/compiler/closure_transformer.mirah", 429, 40, "def return_value; @return_value; end", new ArrayList(0)));
        }
        if (this.void_type?(return_value_type)) {
            list2 = Collections.emptyList();
        } else {
            ArrayList arrayList = new ArrayList(1);
            list2 = arrayList;
            arrayList.add(new RequiredArgument(new SimpleString("return_value"), new SimpleString(return_value_type.name())));
        }
        List required_constructor_arguments = list2;
        Arguments args = new Arguments(node.position(), required_constructor_arguments, Collections.emptyList(), null, Collections.emptyList(), null);
        if (this.void_type?(return_value_type)) {
            list = Collections.emptyList();
        } else {
            ArrayList arrayList = new ArrayList(1);
            list = arrayList;
            arrayList.add(new FieldAssign(new SimpleString("return_value"), new LocalAccess(new SimpleString("return_value")), null));
        }
        List body = list;
        ConstructorDefinition constructor = new ConstructorDefinition(new SimpleString("initialize"), args, new SimpleString("void"), body, null);
        klass.body().add(constructor);
        this.infer(klass);
        return klass;
    }
}

