/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.BindingReference;
import mirah.lang.ast.Block;
import mirah.lang.ast.Call;
import mirah.lang.ast.CallSite;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.Constant;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.LocalAccess;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.Position;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.Script;
import mirah.lang.ast.SimpleString;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Typer;

public class Utils {
    public static ConstructorDefinition build_closure_constructor(Position position, ResolvedType binding_type) {
        ArrayList<RequiredArgument> arrayList = new ArrayList<RequiredArgument>(1);
        arrayList.add(new RequiredArgument(new SimpleString("binding"), Utils.makeTypeName(position, binding_type)));
        Arguments args = new Arguments(position, arrayList, Collections.emptyList(), null, Collections.emptyList(), null);
        FieldAssign body = new FieldAssign(new SimpleString("binding"), new LocalAccess(new SimpleString("binding")), null);
        SimpleString simpleString = new SimpleString("initialize");
        SimpleString simpleString2 = new SimpleString("void");
        ArrayList<FieldAssign> arrayList2 = new ArrayList<FieldAssign>(1);
        arrayList2.add(body);
        return new ConstructorDefinition(simpleString, args, simpleString2, arrayList2, null);
    }

    public static Call closure_call_node(Position position, ClassDefinition klass) {
        Identifier identifier = klass.name();
        SimpleString simpleString = new SimpleString("new");
        ArrayList<BindingReference> arrayList = new ArrayList<BindingReference>(1);
        arrayList.add(new BindingReference());
        return new Call(position, identifier, simpleString, arrayList, null);
    }

    public static void replace_block_with_closure_in_call(CallSite parent, Block block, Node new_node) {
        if (block == parent.block()) {
            parent.block_set(null);
            parent.parameters().add(new_node);
        } else {
            new_node.setParent(null);
            parent.replaceChild(block, new_node);
        }
    }

    public static Node find_enclosing_method_node(Node block) {
        Node class_or_script = block.findAncestor(MethodDefinition.class);
        if (class_or_script == null) {
            class_or_script = block.findAncestor(Script.class);
        }
        return class_or_script;
    }

    public static Node find_enclosing_node(Node block) {
        Node class_or_script = block.findAncestor(ClassDefinition.class);
        if (class_or_script == null) {
            class_or_script = block.findAncestor(Script.class);
        }
        return class_or_script;
    }

    public static NodeList insert_in_front(NodeList nodes, Node new_node) {
        NodeList nodeList = nodes;
        nodeList.insert(0, new_node);
        return nodeList;
    }

    public static NodeList enclosing_body(Node ancestor) {
        return ancestor instanceof MethodDefinition ? ((MethodDefinition)ancestor).body() : ((Script)ancestor).body();
    }

    public static Object inject_nodes(NodeList body, List nodes, Typer typer) {
        for (Object arg : nodes) {
            Node node = (Node)arg;
            Utils.insert_in_front(body, node);
            typer.infer(node);
        }
        return null;
    }

    public static ClosureDefinition build_class(Position position, ResolvedType parent_type, String name) {
        List list;
        if (parent_type != null ? parent_type.isInterface() : false) {
            ArrayList arrayList = new ArrayList(1);
            list = arrayList;
            arrayList.add(Utils.makeTypeName(position, parent_type));
        } else {
            list = Collections.emptyList();
        }
        List interfaces = list;
        boolean $or$5 = parent_type == null;
        Constant superclass = ($or$5 ? $or$5 : parent_type.isInterface()) ? null : Utils.makeTypeName(position, parent_type);
        Constant constant = null;
        if (name != null) {
            constant = new Constant(position, new SimpleString(position, name));
        }
        return new ClosureDefinition(position, constant, superclass, Collections.emptyList(), interfaces, null);
    }

    public static Constant makeTypeName(Position position, ResolvedType type) {
        return new Constant(position, new SimpleString(position, type.name()));
    }

    public static String build_name_prefix(Node block) {
        String string;
        Node class_or_script = Utils.find_enclosing_node(block);
        if (class_or_script instanceof ClassDefinition) {
            string = ((ClassDefinition)class_or_script).name().identifier();
        } else {
            String $or$6 = class_or_script.position().source().name();
            String source_name = $or$6 != null ? $or$6 : "DashE";
            String id = "";
            String[] id_split_on_dash = new File(source_name).getName().replace(".duby|.mirah", "").split("[_-]");
            for (int i = 0; i < id_split_on_dash.length; ++i) {
                String word = id_split_on_dash[i];
                id = id + word.substring(0, 1).toUpperCase() + word.substring(1);
            }
            string = id;
        }
        String outer_name = string;
        return string;
    }

    public static /* bridge */ /* synthetic */ ClosureDefinition build_class(Position position, ResolvedType parent_type) {
        return Utils.build_class(position, parent_type, null);
    }
}

