/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.mirah.builtins.ArrayExtensions;
import org.mirah.builtins.EnumerableExtensions;
import org.mirah.jvm.mirrors.BaseType;
import org.mirah.jvm.mirrors.BytecodeMirrorLoader;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.MirrorTypeSystem;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.mirah.jvm.types.MemberKind;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ArrayType
extends BaseType
implements javax.lang.model.type.ArrayType {
    private MirrorType componentType;
    private MirrorTypeSystem types;
    private ArrayType erasure;
    private static Logger log = Logger.getLogger(ArrayType.class.getName());
    private MirrorType int_type;
    private Context context;

    public static Type getSupertype(MirrorType component) {
        boolean $or$1;
        boolean use_object = JVMTypeUtils.isPrimitive(component);
        if ("Ljava/lang/Object;".equals(component.getAsmType().getDescriptor())) {
            use_object = true;
        }
        return (($or$1 = use_object) ? $or$1 : component.superclass() == null) ? Type.getType("Ljava/lang/Object;") : Type.getType("[" + component.superclass().getAsmType().getDescriptor());
    }

    public ArrayType(Context context, MirrorType component) {
        super(context, Type.getType("[" + component.getAsmType().getDescriptor()), Opcodes.ACC_PUBLIC, null);
        this.context = context;
        this.types = (MirrorTypeSystem)this.context.get(MirrorTypeSystem.class);
        this.int_type = (MirrorType)this.types.wrap(Type.getType("I")).resolve();
        this.componentType = component;
        BytecodeMirrorLoader.extendClass(this, ArrayExtensions.class);
        BytecodeMirrorLoader.extendClass(this, EnumerableExtensions.class);
    }

    @Override
    public TypeFuture[] interfaces() {
        TypeFuture[] typeFutureArray;
        boolean $or$2 = JVMTypeUtils.isPrimitive(this.componentType);
        if ($or$2 ? $or$2 : "Ljava/lang/Object;".equals(this.componentType.getAsmType().getDescriptor())) {
            TypeFuture[] interfaces = new TypeFuture[]{this.types.loadNamedType("java.lang.Object"), this.types.loadNamedType("java.lang.Cloneable"), this.types.loadNamedType("java.io.Serializable")};
            typeFutureArray = interfaces;
        } else {
            List supertypes = this.componentType.directSupertypes();
            TypeFuture[] interfaces = new TypeFuture[supertypes.size()];
            List gensym0 = supertypes;
            ArrayList<BaseTypeFuture> gensym1 = new ArrayList<BaseTypeFuture>(gensym0.size());
            for (Object x : gensym0) {
                BaseTypeFuture baseTypeFuture = new BaseTypeFuture();
                baseTypeFuture.resolved(new ArrayType(this.context, (MirrorType)x));
                gensym1.add(baseTypeFuture);
            }
            gensym1.toArray(interfaces);
            typeFutureArray = interfaces;
        }
        return typeFutureArray;
    }

    public void add_method(String name, List args, ResolvedType returnType, MemberKind kind) {
        this.add(new Member(Opcodes.ACC_PUBLIC, this, name, args, (MirrorType)returnType, kind));
    }

    @Override
    public boolean load_methods() {
        this.add_method("length", new ArrayList(0), this.int_type, MemberKind.ARRAY_LENGTH);
        ArrayList<MirrorType> arrayList = new ArrayList<MirrorType>(1);
        arrayList.add(this.int_type);
        this.add_method("[]", arrayList, this.componentType, MemberKind.ARRAY_ACCESS);
        ArrayList<MirrorType> arrayList2 = new ArrayList<MirrorType>(2);
        arrayList2.add(this.int_type);
        arrayList2.add(this.componentType);
        this.add_method("[]=", arrayList2, this.componentType, MemberKind.ARRAY_ASSIGN);
        return true;
    }

    @Override
    public MirrorType getComponentType() {
        return this.componentType;
    }

    @Override
    public TypeMirror getComponentType() {
        return this.componentType;
    }

    @Override
    public JVMType getComponentType() {
        return this.componentType;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.ARRAY;
    }

    @Override
    public Object accept(TypeVisitor v, Object p) {
        return v.visitArray(this, p);
    }

    @Override
    public int hashCode() {
        return this.componentType.hashCode();
    }

    @Override
    public boolean isSameType(MirrorType other) {
        boolean result = other.getKind() == TypeKind.ARRAY ? this.componentType.isSameType((MirrorType)((javax.lang.model.type.ArrayType)((Object)other)).getComponentType()) : false;
        log.finer(this + " " + (result ? "=" : "!=") + " " + other);
        return result;
    }

    @Override
    public boolean isSupertypeOf(MirrorType other) {
        boolean result = JVMTypeUtils.isPrimitive(this.componentType) ? this.isSameType(other) : (other.getKind() != TypeKind.ARRAY ? false : super.isSupertypeOf(other));
        log.finer(this + " " + (result ? ">" : "!>") + " " + other);
        return result;
    }

    @Override
    public TypeMirror erasure() {
        TypeMirror component;
        return this.erasure != null ? this.erasure : (this.erasure = this.componentType == (component = this.componentType.erasure()) ? this : new ArrayType(this.context, (MirrorType)component));
    }

    @Override
    public String toString() {
        return this.componentType + "[]";
    }
}

