/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.HashSet;
import java.util.logging.Logger;
import org.mirah.jvm.mirrors.AsyncMirror$1;
import org.mirah.jvm.mirrors.AsyncMirror$2;
import org.mirah.jvm.mirrors.AsyncMirror$3;
import org.mirah.jvm.mirrors.BaseType;
import org.mirah.jvm.mirrors.MethodListener;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.types.JVMType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;
import org.objectweb.asm.Type;

public class AsyncMirror
extends BaseType {
    private TypeFuture[] interfaces;
    private static Logger log = Logger.getLogger(AsyncMirror.class.getName());
    private JVMType superclass;
    private HashSet watched_methods = new HashSet();

    public AsyncMirror(Context context, Type type, int flags, TypeFuture superclass, TypeFuture[] interfaces) {
        super(context, type, flags, null);
        this.setSupertypes(superclass, interfaces);
    }

    public AsyncMirror(Context context, Type type, int flags) {
        super(context, type, flags, null);
    }

    public void setSupertypes(TypeFuture superclass, TypeFuture[] interfaces) {
        TypeFuture[] gensym0;
        int gensym1;
        AsyncMirror$1 asyncMirror$1 = new AsyncMirror$1();
        asyncMirror$1.mirror = this;
        this.interfaces = interfaces;
        if (superclass != null) {
            superclass.onUpdate(new AsyncMirror$2(asyncMirror$1));
        }
        if ((gensym1 = 0) < (gensym0 = this.interfaces).length) {
            do {
                TypeFuture i = gensym0[gensym1];
                i.onUpdate(new AsyncMirror$3(asyncMirror$1));
            } while (++gensym1 < gensym0.length);
        }
    }

    public void resolveSuperclass(JVMType resolved) {
        log.finest("[" + this + "] resolving super class " + resolved);
        this.superclass = resolved;
        this.resolveSupertype(resolved);
    }

    public void resolveSupertype(ResolvedType resolved) {
        if (resolved instanceof MirrorType) {
            MirrorType parent = (MirrorType)resolved;
            for (String name : this.watched_methods) {
                parent.addMethodListener(name, this);
            }
        }
        this.notifyOfIncompatibleChange();
    }

    @Override
    public void addMethodListener(String name, MethodListener listener) {
        this.watched_methods.add(name);
        super.addMethodListener(name, listener);
    }

    @Override
    public JVMType superclass() {
        return this.superclass;
    }

    @Override
    public TypeFuture[] interfaces() {
        return this.interfaces;
    }
}

