/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MethodListener;
import org.mirah.jvm.mirrors.MethodLookup;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.generics.LubFinder;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.mirah.typer.ErrorType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class BaseType
implements MirrorType,
DeclaredType,
MethodListener {
    private List cached_supertypes;
    private int flags;
    private Type type;
    private JVMType boxed;
    private boolean methods_loaded;
    private JVMType superclass;
    private List compatibility_listeners;
    private JVMType unboxed;
    private Map members;
    private Context context;
    private String name;
    private static Map kind_map;
    private Map method_listeners;

    static {
        HashMap<String, TypeKind> hashMap = new HashMap<String, TypeKind>(16);
        hashMap.put("Z", TypeKind.BOOLEAN);
        hashMap.put("B", TypeKind.BYTE);
        hashMap.put("C", TypeKind.CHAR);
        hashMap.put("D", TypeKind.DOUBLE);
        hashMap.put("F", TypeKind.FLOAT);
        hashMap.put("I", TypeKind.INT);
        hashMap.put("J", TypeKind.LONG);
        hashMap.put("S", TypeKind.SHORT);
        hashMap.put("V", TypeKind.VOID);
        kind_map = hashMap;
    }

    public BaseType(Context context, Type type, int flags, JVMType superclass) {
        this(context, type.getClassName(), type, flags, superclass);
    }

    public BaseType(Context context, String name, Type type, int flags, JVMType superclass) {
        this.context = context;
        this.name = name;
        this.type = type;
        this.flags = flags;
        this.superclass = superclass;
        this.members = new HashMap(16);
        this.method_listeners = new HashMap(16);
        this.compatibility_listeners = new ArrayList(0);
    }

    @Override
    public JVMType superclass() {
        return this.superclass;
    }

    @Override
    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    @Override
    public int flags() {
        return this.flags;
    }

    public Context context() {
        return this.context;
    }

    @Override
    public void notifyOfIncompatibleChange() {
        this.cached_supertypes = null;
        ArrayList listeners = new ArrayList(this.compatibility_listeners);
        for (Object l : listeners) {
            ((Runnable)l).run();
        }
        HashSet methods = new HashSet(this.method_listeners.keySet());
        for (Object n : methods) {
            this.invalidateMethod((String)n);
        }
    }

    @Override
    public void onIncompatibleChange(Runnable listener) {
        this.compatibility_listeners.add(listener);
    }

    @Override
    public boolean assignableFrom(ResolvedType other) {
        return MethodLookup.isSubTypeWithConversion(other, this);
    }

    @Override
    public ResolvedType widen(ResolvedType other) {
        ResolvedType resolvedType;
        if (this.assignableFrom(other)) {
            resolvedType = this;
        } else if (other.assignableFrom(this)) {
            resolvedType = other;
        } else if (this.box() != null) {
            resolvedType = this.box().widen(other);
        } else if ((other instanceof MirrorType ? ((MirrorType)other).box() : null) != null) {
            resolvedType = this.widen(((MirrorType)other).box());
        } else {
            MirrorType lub;
            LubFinder lubFinder = new LubFinder(this.context);
            ArrayList<ResolvedType> arrayList = new ArrayList<ResolvedType>(2);
            arrayList.add(this);
            arrayList.add(other);
            MirrorType $or$1 = lub = (MirrorType)((Object)lubFinder.leastUpperBound(arrayList));
            if ($or$1 != null) {
                resolvedType = $or$1;
            } else {
                ArrayList arrayList2 = new ArrayList(1);
                ArrayList<String> arrayList3 = new ArrayList<String>(1);
                arrayList3.add("Incompatible types " + this + " and " + other + ".");
                arrayList2.add(arrayList3);
                resolvedType = new ErrorType(arrayList2);
            }
        }
        return resolvedType;
    }

    @Override
    public boolean isMeta() {
        return false;
    }

    @Override
    public boolean isBlock() {
        return false;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean matchesAnything() {
        return false;
    }

    @Override
    public Type getAsmType() {
        return this.type;
    }

    @Override
    public boolean isInterface() {
        return 0 != (this.flags() & Opcodes.ACC_INTERFACE);
    }

    @Override
    public String retention() {
        return null;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.DECLARED;
    }

    public Object accept(TypeVisitor v, Object p) {
        return v.visitDeclared(this, p);
    }

    public List getTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    public JVMType getComponentType() {
        return null;
    }

    @Override
    public boolean hasStaticField(String name) {
        JVMMethod field = this.getDeclaredField(name);
        return field != null ? field.kind().name().startsWith("STATIC_") : false;
    }

    @Override
    public List getDeclaredMethods(String name) {
        if (this.methods_loaded) {
        } else {
            this.methods_loaded = this.load_methods();
        }
        List $or$2 = (List)this.members.get(name);
        return $or$2 != null ? $or$2 : Collections.emptyList();
    }

    @Override
    public List getAllDeclaredMethods() {
        if (this.methods_loaded) {
        } else {
            this.methods_loaded = this.load_methods();
        }
        ArrayList methods = new ArrayList();
        for (Object list : this.members.values()) {
            for (Object m : (List)list) {
                methods.add(m);
            }
        }
        return methods;
    }

    @Override
    public TypeFuture[] interfaces() {
        return new TypeFuture[0];
    }

    @Override
    public JVMMethod[] getDeclaredFields() {
        return new JVMMethod[0];
    }

    @Override
    public JVMMethod getDeclaredField(String name) {
        return null;
    }

    @Override
    public void add(JVMMethod member) {
        Object object;
        Map $ptemp$3 = this.members;
        String $ptemp$4 = member.name();
        Object $or$5 = $ptemp$3.get($ptemp$4);
        if ($or$5 != null) {
            object = $or$5;
        } else {
            LinkedList val0 = new LinkedList();
            $ptemp$3.put($ptemp$4, val0);
            object = val0;
        }
        List members = (List)object;
        members.add((Member)member);
        this.invalidateMethod(member.name());
    }

    @Override
    public void addMethodListener(String name, MethodListener listener) {
        TypeFuture[] gensym1;
        int gensym2;
        Object object;
        if (this.methods_loaded) {
        } else {
            this.methods_loaded = this.load_methods();
        }
        Map $ptemp$6 = this.method_listeners;
        String $ptemp$7 = name;
        Object $or$8 = $ptemp$6.get($ptemp$7);
        if ($or$8 != null) {
            object = $or$8;
        } else {
            HashSet val0 = new HashSet();
            $ptemp$6.put($ptemp$7, val0);
            object = val0;
        }
        Set listeners = (Set)object;
        listeners.add(listener);
        JVMType parent = this.superclass();
        if (parent != null ? parent instanceof MirrorType : false) {
            ((MirrorType)parent).addMethodListener(name, this);
        }
        if ((gensym2 = 0) < (gensym1 = this.interfaces()).length) {
            do {
                ResolvedType iface;
                TypeFuture future;
                if (!(future = gensym1[gensym2]).isResolved() || !((iface = future.resolve()) instanceof MirrorType)) continue;
                ((MirrorType)iface).addMethodListener(name, this);
            } while (++gensym2 < gensym1.length);
        }
    }

    @Override
    public void invalidateMethod(String name) {
        Set listeners = (Set)this.method_listeners.get(name);
        if (listeners != null) {
            for (Object l : new HashSet(listeners)) {
                ((MethodListener)l).methodChanged(this, name);
            }
        }
    }

    @Override
    public void methodChanged(JVMType type, String name) {
        this.invalidateMethod(name);
    }

    @Override
    public void declareField(JVMMethod field) {
        throw new IllegalArgumentException("Cannot add fields to " + this);
    }

    @Override
    public MirrorType unmeta() {
        return this;
    }

    public boolean load_methods() {
        return true;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public JVMType box() {
        return this.boxed;
    }

    public void boxed_set(JVMType value) {
        this.boxed = value;
    }

    @Override
    public JVMType unbox() {
        return this.unboxed;
    }

    public void unboxed_set(JVMType value) {
        this.unboxed = value;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof MirrorType ? this.isSameType((MirrorType)other) : false;
    }

    @Override
    public int hashCode() {
        int hash = 23 + 37 * this.getTypeArguments().hashCode();
        return 37 * hash + this.getAsmType().hashCode();
    }

    @Override
    public boolean isSameType(MirrorType other) {
        if (other == this) {
            return true;
        }
        if (other.getKind() != TypeKind.DECLARED) {
            return false;
        }
        if (!this.getTypeArguments().equals(((DeclaredType)((Object)other)).getTypeArguments())) {
            return false;
        }
        return this.getAsmType().equals(other.getAsmType());
    }

    @Override
    public List directSupertypes() {
        LinkedList<ResolvedType> linkedList;
        if (this.cached_supertypes != null) {
            linkedList = this.cached_supertypes;
        } else {
            TypeFuture[] gensym0;
            int gensym1;
            LinkedList<ResolvedType> supertypes = new LinkedList<ResolvedType>();
            boolean skip_super = JVMTypeUtils.isInterface(this) ? this.interfaces().length > 0 : false;
            boolean $or$9 = this.superclass() == null;
            if (!($or$9 ? $or$9 : skip_super)) {
                supertypes.add(this.superclass());
            }
            if ((gensym1 = 0) < (gensym0 = this.interfaces()).length) {
                do {
                    TypeFuture i;
                    ResolvedType resolved;
                    if (!((resolved = (i = gensym0[gensym1]).resolve()) instanceof MirrorType)) continue;
                    supertypes.add(resolved);
                } while (++gensym1 < gensym0.length);
            }
            linkedList = this.cached_supertypes = supertypes;
        }
        return linkedList;
    }

    @Override
    public boolean isSupertypeOf(MirrorType other) {
        if (this.getAsmType().equals(other.getAsmType())) {
            return true;
        }
        boolean gensym0 = false;
        for (Object x : other.directSupertypes()) {
            if (!this.isSupertypeOf((MirrorType)x)) continue;
            gensym0 = true;
            break;
        }
        return gensym0;
    }

    public List getMembers(String name) {
        return (List)this.members.get(name);
    }

    @Override
    public JVMMethod getMethod(String name, List params) {
        return null;
    }

    @Override
    public TypeMirror erasure() {
        return this;
    }
}

