/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MirrorTypeSystem;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.MemberKind;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class FakeMember
extends Member {
    private String description;

    public static FakeMember create(MirrorTypeSystem types, String description, int flags) {
        Matcher m = Pattern.compile("^(@)?([^.]+)\\.(.+)$").matcher(description);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid method specification " + description);
        }
        boolean bl = !(m.group(1) == null);
        JVMType klass = FakeMember.wrap(types, Type.getType(m.group(2)));
        Type method = Type.getType(m.group(3));
        JVMType returnType = FakeMember.wrap(types, method.getReturnType());
        LinkedList<JVMType> args = new LinkedList<JVMType>();
        int gensym1 = 0;
        Type[] gensym0 = method.getArgumentTypes();
        if (gensym1 < gensym0.length) {
            do {
                Type arg = gensym0[gensym1];
                args.add(FakeMember.wrap(types, arg));
            } while (++gensym1 < gensym0.length);
        }
        if (flags == -1) {
            flags = Opcodes.ACC_PUBLIC;
        }
        if (bl) {
            flags |= Opcodes.ACC_ABSTRACT;
        }
        return new FakeMember(description, flags, klass, returnType, args);
    }

    public static JVMType wrap(MirrorTypeSystem types, Type type) {
        return (JVMType)types.wrap(type).resolve();
    }

    public FakeMember(String description, int flags, JVMType klass, JVMType returnType, List args) {
        super(flags, klass, "foobar", args, returnType, MemberKind.METHOD);
        this.description = description;
    }

    @Override
    public String toString() {
        return this.description;
    }

    public static /* bridge */ /* synthetic */ FakeMember create(MirrorTypeSystem types, String description) {
        return FakeMember.create(types, description, -1);
    }
}

