/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.List;
import org.mirah.jvm.mirrors.MacroMember$1;
import org.mirah.jvm.mirrors.MacroMember$2;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.MirrorTypeSystem;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.MemberKind;
import org.mirah.macros.anno.MacroDef;
import org.mirah.typer.InlineCode;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;
import org.objectweb.asm.Opcodes;

public class MacroMember
extends Member {
    private InlineCode returnType;

    public MacroMember(int flags, JVMType klass, String name, List argumentTypes, InlineCode returnType, MemberKind kind) {
        super(flags, klass, name, argumentTypes, null, kind);
        this.returnType = returnType;
    }

    @Override
    public TypeFuture asyncReturnType() {
        return this.returnType;
    }

    public static InlineCode makeReturnType(Class klass) {
        new MacroMember$1().klass = klass;
        MacroMember$1 macroMember$1 = new MacroMember$1();
        return new InlineCode(new MacroMember$2(macroMember$1));
    }

    public static MacroMember create(Class klass, JVMType declaringClass, Context context) {
        int flags = Opcodes.ACC_PUBLIC;
        MacroDef macrodef = klass.getAnnotation(MacroDef.class);
        if (macrodef.isStatic()) {
            flags |= Opcodes.ACC_STATIC;
        }
        MirrorTypeSystem types = (MirrorTypeSystem)context.get(MirrorTypeSystem.class);
        ArrayList<MirrorType> argumentTypes = new ArrayList<MirrorType>(0);
        int gensym1 = 0;
        String[] gensym0 = macrodef.arguments().required();
        if (gensym1 < gensym0.length) {
            do {
                String name = gensym0[gensym1];
                argumentTypes.add(types.loadMacroType(name));
            } while (++gensym1 < gensym0.length);
        }
        MemberKind kind = macrodef.isStatic() ? MemberKind.STATIC_METHOD : MemberKind.METHOD;
        return new MacroMember(flags, declaringClass, macrodef.name(), argumentTypes, MacroMember.makeReturnType(klass), kind);
    }
}

