/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.mirah.jvm.types.GenericMethod;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.MemberKind;
import org.mirah.jvm.types.MemberVisitor;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.objectweb.asm.Opcodes;

public class Member
implements GenericMethod {
    private BaseTypeFuture returnFuture;
    private static Logger log = Logger.getLogger(Member.class.getName());
    private String signature;
    private MemberKind kind;
    private int flags;
    private String name;
    private JVMType genericReturnType;
    private List argumentTypes;
    private JVMType returnType;
    private JVMType declaringClass;

    public Member(int flags, JVMType klass, String name, List argumentTypes, JVMType returnType, MemberKind kind) {
        this.flags = flags;
        this.declaringClass = klass;
        this.name = name;
        this.argumentTypes = Collections.unmodifiableList(new ArrayList(argumentTypes));
        this.returnType = returnType;
        this.kind = kind;
    }

    @Override
    public JVMType declaringClass() {
        return this.declaringClass;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List argumentTypes() {
        return this.argumentTypes;
    }

    @Override
    public JVMType returnType() {
        return this.returnType;
    }

    @Override
    public MemberKind kind() {
        return this.kind;
    }

    public int flags() {
        return this.flags;
    }

    public String signature() {
        return this.signature;
    }

    public void signature_set(String value) {
        this.signature = value;
    }

    public void genericReturnType_set(JVMType value) {
        this.genericReturnType = value;
    }

    @Override
    public JVMType genericReturnType() {
        JVMType $or$1 = this.genericReturnType;
        return $or$1 != null ? $or$1 : this.returnType();
    }

    public TypeFuture asyncArgument(int index) {
        BaseTypeFuture baseTypeFuture = new BaseTypeFuture(null);
        baseTypeFuture.resolved((ResolvedType)this.argumentTypes().get(index));
        return baseTypeFuture;
    }

    public TypeFuture asyncReturnType() {
        BaseTypeFuture baseTypeFuture;
        if (this.returnFuture != null) {
            baseTypeFuture = this.returnFuture;
        } else {
            BaseTypeFuture baseTypeFuture2 = new BaseTypeFuture();
            JVMType $or$2 = this.genericReturnType;
            baseTypeFuture2.resolved($or$2 != null ? $or$2 : this.returnType);
            baseTypeFuture = this.returnFuture = baseTypeFuture2;
        }
        return baseTypeFuture;
    }

    @Override
    public void accept(MemberVisitor visitor, boolean expression) {
        String kind = this.kind.name().intern();
        if (kind == "MATH_OP") {
            visitor.visitMath(this, expression);
        } else if (kind == "COMPARISON_OP") {
            visitor.visitComparison(this, expression);
        } else if (kind == "METHOD") {
            visitor.visitMethodCall(this, expression);
        } else if (kind == "STATIC_METHOD") {
            visitor.visitStaticMethodCall(this, expression);
        } else if (kind == "FIELD_ACCESS") {
            visitor.visitFieldAccess(this, expression);
        } else if (kind == "STATIC_FIELD_ACCESS") {
            visitor.visitStaticFieldAccess(this, expression);
        } else if (kind == "FIELD_ASSIGN") {
            visitor.visitFieldAssign(this, expression);
        } else if (kind == "STATIC_FIELD_ASSIGN") {
            visitor.visitStaticFieldAssign(this, expression);
        } else if (kind == "CONSTRUCTOR") {
            visitor.visitConstructor(this, expression);
        } else if (kind == "STATIC_INITIALIZER") {
            visitor.visitStaticInitializer(this, expression);
        } else if (kind == "ARRAY_ACCESS") {
            visitor.visitArrayAccess(this, expression);
        } else if (kind == "ARRAY_ASSIGN") {
            visitor.visitArrayAssign(this, expression);
        } else if (kind == "ARRAY_LENGTH") {
            visitor.visitArrayLength(this, expression);
        } else if (kind == "CLASS_LITERAL") {
            visitor.visitClassLiteral(this, expression);
        } else if (kind == "INSTANCEOF") {
            visitor.visitInstanceof(this, expression);
        } else if (kind == "IS_NULL") {
            visitor.visitIsNull(this, expression);
        } else {
            throw new IllegalArgumentException("Member " + kind + " not supported");
        }
    }

    @Override
    public boolean isVararg() {
        return 0 != (this.flags & Opcodes.ACC_VARARGS);
    }

    @Override
    public boolean isAbstract() {
        return 0 != (this.flags & Opcodes.ACC_ABSTRACT);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.declaringClass());
        result.append(".");
        result.append(this.name());
        result.append("(");
        boolean first = true;
        for (Object t : this.argumentTypes()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(t);
        }
        result.append(")");
        return result.toString();
    }
}

