/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import mirah.lang.ast.Position;
import org.mirah.MirahLogFormatter;
import org.mirah.jvm.mirrors.AsyncMember;
import org.mirah.jvm.mirrors.DebugError;
import org.mirah.jvm.mirrors.FakeMember;
import org.mirah.jvm.mirrors.JVMScope;
import org.mirah.jvm.mirrors.LookupState;
import org.mirah.jvm.mirrors.MacroMember;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MethodLookup$1;
import org.mirah.jvm.mirrors.MethodLookup$2;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.MirrorTypeSystem;
import org.mirah.jvm.mirrors.NullType;
import org.mirah.jvm.mirrors.Phase1Checker;
import org.mirah.jvm.mirrors.Phase2Checker;
import org.mirah.jvm.mirrors.SubtypeChecker;
import org.mirah.jvm.mirrors.debug.DebuggerInterface;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.mirah.jvm.types.MemberKind;
import org.mirah.typer.DerivedFuture;
import org.mirah.typer.MethodType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;
import org.objectweb.asm.Opcodes;

public class MethodLookup {
    private static Logger log = Logger.getLogger(MethodLookup.class.getName());
    private Context context;

    public MethodLookup(Context context) {
        this.context = context;
    }

    public static boolean isPrimitive(JVMType type) {
        return JVMTypeUtils.isPrimitive(type);
    }

    public static boolean isArray(JVMType type) {
        return JVMTypeUtils.isArray(type);
    }

    public static boolean isSubType(ResolvedType subtype, ResolvedType supertype) {
        if (subtype == supertype) {
            return true;
        }
        if (subtype instanceof JVMType ? supertype instanceof JVMType : false) {
            return MethodLookup.isJvmSubType((JVMType)subtype, (JVMType)supertype);
        }
        if (subtype.matchesAnything()) {
            return true;
        }
        return supertype.matchesAnything();
    }

    public static boolean isJvmSubType(JVMType subtype, JVMType supertype) {
        boolean $or$1 = subtype.matchesAnything();
        if ($or$1 ? $or$1 : supertype.matchesAnything()) {
            return true;
        }
        if ("null".equals(subtype.name())) {
            return !MethodLookup.isPrimitive(supertype);
        }
        if (subtype.isBlock()) {
            if (JVMTypeUtils.isInterface(supertype)) {
                return true;
            }
            if (JVMTypeUtils.isAbstract(supertype)) {
                return true;
            }
        }
        return ((MirrorType)supertype).isSupertypeOf((MirrorType)subtype);
    }

    public static boolean isPrimitiveSubType(JVMType subtype, JVMType supertype) {
        return ((MirrorType)supertype).isSupertypeOf((MirrorType)subtype);
    }

    public static boolean isArraySubType(JVMType subtype, JVMType supertype) {
        return ((MirrorType)supertype).isSupertypeOf((MirrorType)subtype);
    }

    public static boolean isSubTypeWithConversion(ResolvedType subtype, ResolvedType supertype) {
        return MethodLookup.isSubType(subtype, supertype) ? true : ((subtype instanceof JVMType ? supertype instanceof JVMType : false) ? MethodLookup.isSubTypeViaBoxing((JVMType)subtype, (JVMType)supertype) : false);
    }

    public static boolean isSubTypeViaBoxing(JVMType subtype, JVMType supertype) {
        if (MethodLookup.isPrimitive(subtype)) {
            if (subtype.box() != null) {
                return MethodLookup.isJvmSubType(subtype.box(), supertype);
            }
        } else if (subtype.unbox() != null) {
            return MethodLookup.isJvmSubType(subtype.unbox(), supertype);
        }
        return false;
    }

    public static double subtypeComparison(ResolvedType a, ResolvedType b) {
        if (a.isError()) {
            if (b.isError()) {
                return 0.0;
            }
            return -1.0;
        }
        if (b.isError()) {
            return 1.0;
        }
        MirrorType jvm_a = (MirrorType)a;
        MirrorType jvm_b = (MirrorType)b;
        if (jvm_a.isSameType(jvm_b)) {
            return 0.0;
        }
        if (MethodLookup.isJvmSubType(jvm_b, jvm_a)) {
            return -1.0;
        }
        if (MethodLookup.isJvmSubType(jvm_a, jvm_b)) {
            return 1.0;
        }
        return Double.NaN;
    }

    public static List findMaximallySpecific(List methods, List params) {
        LinkedList<JVMMethod> maximal = new LinkedList<JVMMethod>();
        boolean ambiguous = false;
        for (Object m : methods) {
            JVMMethod method = (JVMMethod)m;
            boolean most_specific = true;
            boolean more_specific = true;
            boolean method_ambiguous = false;
            Iterator gensym1 = maximal.iterator();
            while (gensym1.hasNext()) {
                JVMMethod x;
                JVMMethod item = x = (JVMMethod)gensym1.next();
                double comparison = MethodLookup.compareSpecificity(method, item, params);
                log.finest("compareSpecificity('" + method + "', '" + item + "') = " + comparison);
                if (comparison < 0.0) {
                    more_specific = false;
                    most_specific = false;
                    break;
                }
                if (comparison == 0.0) {
                    most_specific = false;
                    continue;
                }
                if (!Double.isNaN(comparison)) continue;
                most_specific = false;
                method_ambiguous = true;
            }
            if (most_specific) {
                maximal.clear();
                maximal.add(method);
                ambiguous = false;
                continue;
            }
            if (!more_specific) continue;
            maximal.add(method);
            if (!method_ambiguous) continue;
            ambiguous = true;
        }
        boolean bl = maximal.size() > 1 ? !ambiguous : false;
        if (bl) {
            return Collections.singletonList(MethodLookup.pickMostSpecific(maximal));
        }
        return maximal;
    }

    public static double compareSpecificity(JVMMethod a, JVMMethod b, List params) {
        double target_comparison;
        boolean $or$2;
        int last_b;
        int last_a = a.argumentTypes().size() - 1;
        boolean bl = last_a != (last_b = b.argumentTypes().size() - 1) ? !(a.isVararg() ? b.isVararg() : false) : false;
        if (bl) {
            throw new IllegalArgumentException();
        }
        double comparison = 0.0;
        int i = 0;
        int gensym0 = Math.max(a.argumentTypes().size(), b.argumentTypes().size());
        if (i < gensym0) {
            do {
                ResolvedType a_arg = MethodLookup.getMethodArgument(a.argumentTypes(), i, a.isVararg());
                ResolvedType b_arg = MethodLookup.getMethodArgument(b.argumentTypes(), i, b.isVararg());
                double arg_comparison = MethodLookup.subtypeComparison(a_arg, b_arg);
                if (params.get(i) instanceof NullType) {
                    arg_comparison *= (double)-1;
                }
                if (Double.isNaN(arg_comparison)) {
                    return arg_comparison;
                }
                if (arg_comparison == 0.0) continue;
                if (comparison == 0.0) {
                    comparison = arg_comparison;
                    continue;
                }
                if (comparison == arg_comparison) continue;
                return Double.NaN;
            } while (++i < gensym0);
        }
        boolean bl2 = $or$2 = comparison == (target_comparison = MethodLookup.subtypeComparison(a.declaringClass(), b.declaringClass()));
        if ($or$2 ? $or$2 : target_comparison == 0.0) {
            return comparison;
        }
        if (comparison == 0.0) {
            if (Double.isNaN(target_comparison)) {
                return comparison;
            }
            return target_comparison;
        }
        return Double.NaN;
    }

    public static ResolvedType getMethodArgument(List arguments, int index, boolean isVararg) {
        ResolvedType type;
        int last_index = arguments.size() - 1;
        return (isVararg ? index >= last_index : false) ? ((type = (ResolvedType)arguments.get(last_index)).isError() ? type : ((JVMType)type).getComponentType()) : (ResolvedType)arguments.get(index);
    }

    public static JVMMethod pickMostSpecific(List methods) {
        JVMMethod method = null;
        for (Object m : methods) {
            method = (JVMMethod)m;
            if (method.isAbstract()) continue;
            return method;
        }
        return method;
    }

    public TypeFuture findMethod(Scope scope, MirrorType target, String name, List params, List macro_params, Position position, boolean includeStaticImports) {
        boolean is_static_scope;
        List potentials = this.gatherMethods(target, name);
        boolean bl = (scope != null ? scope.selfType() : null) != null ? target == scope.selfType().resolve() : (is_static_scope = false);
        if ((includeStaticImports ? potentials.isEmpty() : false) ? is_static_scope : false) {
            potentials = this.gatherStaticImports((JVMScope)scope, name);
        }
        LookupState state = new LookupState(this.context, scope, target, potentials, position);
        state.search(params, macro_params);
        state.searchFields(name);
        log.fine("findMatchingMethod(" + target + "." + name + params + ") => " + state);
        return state.future(false);
    }

    public List findOverrides(MirrorType target, String name, int arity) {
        HashMap results = new HashMap(16);
        if (!target.isMeta()) {
            for (Object m : this.gatherMethods(target, name)) {
                boolean member_is_static;
                Member member = (Member)m;
                if (member.declaringClass() == target || member instanceof MacroMember) continue;
                boolean bl = member_is_static = 0 != (member.flags() & Opcodes.ACC_STATIC);
                if (member.argumentTypes().size() != arity) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(member.argumentTypes());
                arrayList.add(member.asyncReturnType().resolve());
                results.put(arrayList, member);
            }
        }
        return new ArrayList(results.values());
    }

    public TypeFuture makeFuture(MirrorType target, Member method, List params, Position position, LookupState state) {
        new MethodLookup$1().target = target;
        new MethodLookup$1().method = method;
        new MethodLookup$1().state = state;
        MethodLookup$1 methodLookup$1 = new MethodLookup$1();
        if ((DebuggerInterface)this.context.get(DebuggerInterface.class) == null) {
            methodLookup$1.state = null;
        }
        return new DerivedFuture(methodLookup$1.method.asyncReturnType(), new MethodLookup$2(methodLookup$1));
    }

    public TypeFuture inaccessible(Scope scope, Member method, Position position, LookupState state) {
        ArrayList arrayList = new ArrayList(1);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        arrayList2.add("Cannot access " + method + " from " + scope.selfType().resolve());
        arrayList2.add(position);
        arrayList.add(arrayList2);
        return new DebugError(arrayList, this.context, state);
    }

    public List gatherMethods(MirrorType target, String name) {
        LinkedList methods = new LinkedList();
        HashSet types = new HashSet();
        return this.gatherMethodsInternal(target, name, methods, types);
    }

    public List gatherStaticImports(JVMScope scope, String name) {
        LinkedList methods = new LinkedList();
        HashSet types = new HashSet();
        for (Object type : scope.staticImports()) {
            ResolvedType resolved = ((TypeFuture)type).resolve();
            if (!(resolved instanceof MirrorType)) continue;
            this.gatherMethodsInternal((MirrorType)resolved, name, methods, types);
        }
        return methods;
    }

    public List gatherMethodsInternal(MirrorType target, String name, List methods, Set visited) {
        boolean $or$3;
        boolean $or$4;
        if (target != null) {
            target = target.unmeta();
        }
        if (!(($or$4 = ($or$3 = target == null) ? $or$3 : target.isError()) ? $or$4 : visited.contains(target))) {
            visited.add(target);
            methods.addAll(target.getDeclaredMethods(name));
            if ("<init>".equals(name)) {
                return methods;
            }
            for (Object t : target.directSupertypes()) {
                this.gatherMethodsInternal((MirrorType)t, name, methods, visited);
            }
        }
        return methods;
    }

    public List gatherAbstractMethods(MirrorType target) {
        HashSet defined_methods = new HashSet();
        HashMap abstract_methods = new HashMap(16);
        HashSet visited = new HashSet();
        this.gatherAbstractMethodsInternal(target, defined_methods, abstract_methods, visited);
        abstract_methods.keySet().removeAll(defined_methods);
        return new ArrayList(abstract_methods.values());
    }

    public void gatherAbstractMethodsInternal(MirrorType target, Set defined_methods, Map abstract_methods, Set visited) {
        boolean $or$5;
        boolean $or$6;
        if (target != null) {
            target = target.unmeta();
        }
        if (!(($or$6 = ($or$5 = target == null) ? $or$5 : target.isError()) ? $or$6 : visited.contains(target))) {
            visited.add(target);
            for (Object m : target.getAllDeclaredMethods()) {
                JVMMethod member = (JVMMethod)m;
                if (member.isAbstract()) {
                    MethodType type = new MethodType(member.name(), member.argumentTypes(), member.returnType(), member.isVararg());
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(member.name());
                    arrayList.add(member.argumentTypes());
                    abstract_methods.put(arrayList, type);
                    continue;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(member.name());
                arrayList.add(member.argumentTypes());
                defined_methods.add(arrayList);
            }
            for (Object t : target.directSupertypes()) {
                this.gatherAbstractMethodsInternal((MirrorType)t, defined_methods, abstract_methods, visited);
            }
        }
    }

    public List gatherFields(MirrorType target, String name) {
        boolean setter = false;
        if (name.endsWith("_set")) {
            name = name.substring(0, name.length() - 4);
            setter = true;
        }
        LinkedList fields = new LinkedList();
        MirrorType mirror = target.unmeta();
        this.gatherFieldsInternal(target, name, setter, fields, new HashSet());
        return fields;
    }

    public void gatherFieldsInternal(MirrorType target, String name, boolean isSetter, List fields, Set visited) {
        boolean $or$7 = target == null;
        boolean $or$8 = $or$7 ? $or$7 : target.isError();
        if (!($or$8 ? $or$8 : visited.contains(target))) {
            visited.add(target);
            JVMMethod field = target.getDeclaredField(name);
            if (field != null) {
                if (isSetter) {
                    field = this.makeSetter((Member)field);
                }
                fields.add(field);
            }
            for (Object t : target.directSupertypes()) {
                this.gatherFieldsInternal((MirrorType)t, name, isSetter, fields, visited);
            }
        }
    }

    public AsyncMember makeSetter(Member field) {
        MemberKind kind = field.kind() == MemberKind.FIELD_ACCESS ? MemberKind.FIELD_ASSIGN : MemberKind.STATIC_FIELD_ASSIGN;
        int n = field.flags();
        MirrorType mirrorType = (MirrorType)field.declaringClass();
        String string = field.name() + "=";
        ArrayList<TypeFuture> arrayList = new ArrayList<TypeFuture>(1);
        arrayList.add(field.asyncReturnType());
        return new AsyncMember(n, mirrorType, string, arrayList, field.asyncReturnType(), kind);
    }

    public List findMatchingMethod(List potentials, List params) {
        List list;
        boolean bl;
        boolean bl2 = params != null ? !potentials.isEmpty() : false;
        if (bl2) {
            boolean gensym1 = true;
            for (Object gensym0 : params) {
                if (gensym0 != null) continue;
                gensym1 = false;
                break;
            }
            bl = gensym1;
        } else {
            bl = false;
        }
        if (bl) {
            List $or$10;
            List $or$9 = this.phase1(potentials, params);
            List list2 = $or$10 = $or$9 != null ? $or$9 : this.phase2(potentials, params);
            list = $or$10 != null ? $or$10 : this.phase3(potentials, params);
        } else {
            list = null;
        }
        return list;
    }

    public List phase1(List potentials, List params) {
        return this.findMatchingArityMethod(new Phase1Checker(), potentials, params);
    }

    public List findMatchingArityMethod(SubtypeChecker phase, List potentials, List params) {
        int arity = params.size();
        LinkedList<Member> phase_methods = new LinkedList<Member>();
        for (Object m : potentials) {
            Member member = (Member)m;
            List args = member.argumentTypes();
            if (args.size() != arity) continue;
            boolean match = true;
            int i = 0;
            int gensym1 = arity;
            if (i < gensym1) {
                do {
                    if (phase.isSubType((ResolvedType)params.get(i), (ResolvedType)args.get(i))) continue;
                    match = false;
                    break;
                } while (++i < gensym1);
            }
            if (!match) continue;
            phase_methods.add(member);
        }
        return phase_methods.size() == 0 ? null : (phase_methods.size() > 1 ? MethodLookup.findMaximallySpecific(phase_methods, params) : phase_methods);
    }

    public List phase2(List potentials, List params) {
        return this.findMatchingArityMethod(new Phase2Checker(), potentials, params);
    }

    public List phase3(List potentials, List params) {
        int arity = params.size();
        LinkedList<Member> phase3_methods = new LinkedList<Member>();
        for (Object m : potentials) {
            List args;
            int required_count;
            Member member = (Member)m;
            if (!member.isVararg() || (required_count = (args = member.argumentTypes()).size() - 1) > arity) continue;
            boolean match = true;
            int i = 0;
            int gensym1 = arity;
            if (i < gensym1) {
                do {
                    ResolvedType arg;
                    ResolvedType param;
                    if (MethodLookup.isSubTypeWithConversion(param = (ResolvedType)params.get(i), arg = MethodLookup.getMethodArgument(args, i, true))) continue;
                    match = false;
                    break;
                } while (++i < gensym1);
            }
            if (!match) continue;
            phase3_methods.add(member);
        }
        return phase3_methods.size() == 0 ? null : (phase3_methods.size() > 1 ? MethodLookup.findMaximallySpecific(phase3_methods, params) : phase3_methods);
    }

    public static boolean isAccessible(JVMType type, int access, Scope scope, JVMType target) {
        boolean $or$11;
        if (scope == null) {
            return true;
        }
        boolean bl = (target != null ? target.isMeta() : false) ? 0 == (access & Opcodes.ACC_STATIC) : false;
        if (bl) {
            return false;
        }
        boolean bl2 = $or$11 = scope == null;
        if ($or$11 ? $or$11 : scope.selfType() == null) {
            return 0 != (access & Opcodes.ACC_PUBLIC);
        }
        MirrorType selfType = (MirrorType)scope.selfType().resolve();
        boolean $or$12 = 0 != (access & Opcodes.ACC_PUBLIC);
        return ($or$12 ? $or$12 : type.getAsmType().getDescriptor().equals(selfType.getAsmType().getDescriptor())) ? true : (0 != (access & Opcodes.ACC_PRIVATE) ? false : (MethodLookup.getPackage(type).equals(MethodLookup.getPackage(selfType)) ? true : (0 != (access & Opcodes.ACC_PROTECTED) ? MethodLookup.isJvmSubType(selfType, type) : false)));
    }

    public static String getPackage(JVMType type) {
        String name = type.getAsmType().getInternalName();
        int lastslash = name.lastIndexOf(47);
        return lastslash == -1 ? "" : name.substring(0, lastslash);
    }

    public List removeInaccessible(List methods, Scope scope, JVMType target) {
        LinkedList<Member> inaccessible = new LinkedList<Member>();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            Member method = (Member)it.next();
            boolean accessible = true;
            if (!MethodLookup.isAccessible(method.declaringClass(), method.declaringClass().flags(), scope, null)) {
                accessible = false;
            }
            if (!MethodLookup.isAccessible(method.declaringClass(), method.flags(), scope, target)) {
                accessible = false;
            }
            if (accessible) continue;
            it.remove();
            inaccessible.add(method);
        }
        return inaccessible;
    }

    public static void main(String[] args) {
        Logger logger = new MirahLogFormatter(true).install();
        log.setLevel(Level.ALL);
        MirrorTypeSystem types = new MirrorTypeSystem();
        LinkedList<FakeMember> methods = new LinkedList<FakeMember>();
        String[] gensym0 = args;
        int gensym1 = 0;
        if (gensym1 < gensym0.length) {
            do {
                String arg = gensym0[gensym1];
                methods.add(FakeMember.create(types, arg));
            } while (++gensym1 < gensym0.length);
        }
        System.out.println(MethodLookup.findMaximallySpecific(methods, new ArrayList(0)));
    }
}

