/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVisitor;
import org.mirah.jvm.mirrors.BaseType;
import org.mirah.jvm.mirrors.BytecodeMirrorLoader;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MirrorLoader;
import org.mirah.jvm.mirrors.MirrorNumberExtensions;
import org.mirah.jvm.mirrors.MirrorObjectExtensions;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.types.MemberKind;
import org.mirah.util.Context;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class Number
extends BaseType
implements PrimitiveType {
    private TypeKind kind;
    private MirrorLoader loader;
    private static Map kind_map;

    static {
        HashMap<String, TypeKind> hashMap = new HashMap<String, TypeKind>(16);
        hashMap.put("Z", TypeKind.BOOLEAN);
        hashMap.put("B", TypeKind.BYTE);
        hashMap.put("C", TypeKind.CHAR);
        hashMap.put("D", TypeKind.DOUBLE);
        hashMap.put("F", TypeKind.FLOAT);
        hashMap.put("I", TypeKind.INT);
        hashMap.put("J", TypeKind.LONG);
        hashMap.put("S", TypeKind.SHORT);
        kind_map = hashMap;
    }

    public Number(Context context, Type type, MirrorType supertype, MirrorLoader loader) {
        super(context, type, Opcodes.ACC_PUBLIC, supertype);
        this.kind = (TypeKind)((Object)kind_map.get(type.getDescriptor()));
        this.loader = loader;
    }

    @Override
    public boolean load_methods() {
        int sort = this.getAsmType().getSort();
        MirrorType mirrorType = this.loader.loadMirror(Type.BOOLEAN_TYPE);
        this.add_operators(this.loader.loadMirror(Type.DOUBLE_TYPE), mirrorType);
        if (sort != Type.DOUBLE) {
            this.add_operators(this.loader.loadMirror(Type.FLOAT_TYPE), mirrorType);
            if (sort != Type.FLOAT) {
                this.add_operators(this.loader.loadMirror(Type.LONG_TYPE), mirrorType);
            }
            if (sort <= Type.INT) {
                this.add_operators(this.loader.loadMirror(Type.INT_TYPE), mirrorType);
            }
        }
        BytecodeMirrorLoader.extendClass(this, MirrorObjectExtensions.class);
        BytecodeMirrorLoader.extendClass(this, MirrorNumberExtensions.class);
        return true;
    }

    public void add_operators(MirrorType type, MirrorType mirrorType) {
        block0: {
            boolean $or$1;
            this.add_comparisons(type, mirrorType);
            this.add_math("+", type);
            this.add_math("-", type);
            this.add_math("*", type);
            this.add_math("/", type);
            this.add_math("%", type);
            int sort = type.getAsmType().getSort();
            boolean bl = $or$1 = sort == Type.INT;
            if (!($or$1 ? $or$1 : sort == Type.LONG)) break block0;
            this.add_math("<<", type);
            this.add_math(">>", type);
            this.add_math(">>>", type);
            this.add_math("|", type);
            this.add_math("&", type);
            this.add_math("^", type);
        }
    }

    public void add_comparisons(MirrorType type, MirrorType mirrorType) {
        this.add_comparison("<", type, mirrorType);
        this.add_comparison("<=", type, mirrorType);
        this.add_comparison("==", type, mirrorType);
        this.add_comparison("!=", type, mirrorType);
        this.add_comparison(">", type, mirrorType);
        this.add_comparison(">=", type, mirrorType);
    }

    public void add_math(String name, MirrorType type) {
        ArrayList<MirrorType> arrayList = new ArrayList<MirrorType>(1);
        arrayList.add(type);
        this.add(new Member(Opcodes.ACC_PUBLIC, type, name, arrayList, type, MemberKind.MATH_OP));
    }

    public void add_comparison(String name, MirrorType type, MirrorType mirrorType) {
        ArrayList<MirrorType> arrayList = new ArrayList<MirrorType>(1);
        arrayList.add(type);
        this.add(new Member(Opcodes.ACC_PUBLIC, type, name, arrayList, mirrorType, MemberKind.COMPARISON_OP));
    }

    @Override
    public TypeKind getKind() {
        return this.kind;
    }

    @Override
    public Object accept(TypeVisitor v, Object p) {
        return v.visitPrimitive(this, p);
    }

    @Override
    public boolean isSameType(MirrorType other) {
        return this.kind.equals((Object)other.getKind());
    }

    @Override
    public int hashCode() {
        return this.kind.hashCode();
    }
}

